/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.handler;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.smarthome.binding.homematic.handler.GatewayNotAvailableException;
import org.eclipse.smarthome.binding.homematic.handler.HomematicBridgeHandler;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterFactory;
import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterTypeException;
import org.eclipse.smarthome.binding.homematic.internal.converter.TypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicTypeGeneratorImpl;
import org.eclipse.smarthome.binding.homematic.internal.type.MetadataUtils;
import org.eclipse.smarthome.binding.homematic.internal.type.UidUtils;
import org.eclipse.smarthome.config.core.Configuration;
import org.eclipse.smarthome.config.core.validation.ConfigValidationException;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Channel;
import org.eclipse.smarthome.core.thing.ChannelUID;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingStatus;
import org.eclipse.smarthome.core.thing.ThingStatusDetail;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandler;
import org.eclipse.smarthome.core.thing.binding.BridgeHandler;
import org.eclipse.smarthome.core.thing.binding.builder.ChannelBuilder;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.RefreshType;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.core.types.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HomematicThingHandler
extends BaseThingHandler {
    private final Logger logger = LoggerFactory.getLogger(HomematicThingHandler.class);
    private Future<?> initFuture;
    private final Object initLock = new Object();
    private volatile boolean deviceDeletionPending = false;

    public HomematicThingHandler(Thing thing) {
        super(thing);
    }

    public void initialize() {
        if (this.initFuture != null) {
            return;
        }
        this.initFuture = this.scheduler.submit(() -> {
            this.initFuture = null;
            try {
                Object object = this.initLock;
                synchronized (object) {
                    this.doInitializeInBackground();
                }
            }
            catch (HomematicClientException ex) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.CONFIGURATION_ERROR, ex.getMessage());
            }
            catch (IOException ex) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.COMMUNICATION_ERROR, ex.getMessage());
            }
            catch (GatewayNotAvailableException ex) {
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.BRIDGE_OFFLINE, ex.getMessage());
            }
            catch (Exception ex) {
                this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.NONE, ex.getMessage());
            }
        });
    }

    private void doInitializeInBackground() throws GatewayNotAvailableException, HomematicClientException, IOException {
        HomematicGateway gateway = this.getHomematicGateway();
        HmDevice device = gateway.getDevice(UidUtils.getHomematicAddress(this.getThing()));
        HmChannel channelZero = device.getChannel(0);
        this.loadHomematicChannelValues(channelZero);
        this.updateStatus(device);
        this.logger.debug("Initializing thing '{}' from gateway '{}'", (Object)this.getThing().getUID(), (Object)gateway.getId());
        Map properties = this.editProperties();
        this.setProperty(properties, channelZero, "batteryType", "BATTERY_TYPE");
        this.setProperty(properties, channelZero, "firmwareVersion", "FIRMWARE");
        this.setProperty(properties, channelZero, "serialNumber", device.getAddress());
        this.setProperty(properties, channelZero, "aesKey", "AES_KEY");
        this.updateProperties(properties);
        for (HmChannel channel : device.getChannels()) {
            if (!channel.isReconfigurable()) continue;
            this.loadHomematicChannelValues(channel);
            if (!channel.checkForChannelFunctionChange()) continue;
            gateway.updateChannelValueDatapoints(channel);
        }
        Configuration config = this.editConfiguration();
        for (HmChannel channel : device.getChannels()) {
            this.loadHomematicChannelValues(channel);
            for (HmDatapoint dp : channel.getDatapoints()) {
                if (dp.getParamsetType() != HmParamsetType.MASTER) continue;
                config.put(MetadataUtils.getParameterName(dp), dp.isEnumType() ? dp.getOptionValue() : dp.getValue());
            }
        }
        this.updateConfiguration(config);
        ArrayList<Channel> thingChannels = new ArrayList<Channel>(this.getThing().getChannels());
        if (this.updateDynamicChannelList(device, thingChannels)) {
            this.updateThing(this.editThing().withChannels(thingChannels).build());
        }
    }

    private boolean updateDynamicChannelList(HmDevice device, List<Channel> thingChannels) {
        boolean changed = false;
        for (HmChannel channel : device.getChannels()) {
            if (!channel.isReconfigurable()) continue;
            String expectedFunction = channel.getDatapoint(HmParamsetType.MASTER, "CHANNEL_FUNCTION").getOptionValue();
            String propertyName = String.format("dynamicFunction-%d", channel.getNumber());
            Iterator<Channel> channelIter = thingChannels.iterator();
            while (channelIter.hasNext()) {
                Map properties = channelIter.next().getProperties();
                String function = (String)properties.get(propertyName);
                if (function == null || function.equals(expectedFunction)) continue;
                channelIter.remove();
                changed = true;
            }
            for (HmDatapoint dp : channel.getDatapoints()) {
                ChannelUID channelUID;
                if (HomematicTypeGeneratorImpl.isIgnoredDatapoint(dp) || dp.getParamsetType() != HmParamsetType.VALUES || HomematicThingHandler.containsChannel(thingChannels, channelUID = UidUtils.generateChannelUID(dp, this.getThing().getUID()))) continue;
                HashMap<String, String> channelProps = new HashMap<String, String>();
                channelProps.put(propertyName, expectedFunction);
                Channel thingChannel = ChannelBuilder.create((ChannelUID)channelUID, (String)MetadataUtils.getItemType(dp)).withProperties(channelProps).withLabel(MetadataUtils.getLabel(dp)).withDescription(MetadataUtils.getDatapointDescription(dp)).withType(UidUtils.generateChannelTypeUID(dp)).build();
                thingChannels.add(thingChannel);
                changed = true;
            }
        }
        return changed;
    }

    private static boolean containsChannel(List<Channel> channels, ChannelUID channelUID) {
        for (Channel channel : channels) {
            ChannelUID uid = channel.getUID();
            if (!StringUtils.equals((String)channelUID.getGroupId(), (String)uid.getGroupId()) || !StringUtils.equals((String)channelUID.getId(), (String)uid.getId())) continue;
            return true;
        }
        return false;
    }

    private void setProperty(Map<String, String> properties, HmChannel channelZero, String propertyName, String datapointName) {
        HmDatapoint dp = channelZero.getDatapoint(new HmDatapointInfo(HmParamsetType.VALUES, channelZero, datapointName));
        if (dp != null) {
            properties.put(propertyName, ObjectUtils.toString((Object)dp.getValue()));
        }
    }

    public void channelLinked(ChannelUID channelUID) {
        this.handleRefresh(channelUID);
    }

    protected void handleRefresh(ChannelUID channelUID) {
        try {
            if (this.thing.getStatus() == ThingStatus.ONLINE) {
                this.logger.debug("Updating channel '{}' from thing id '{}'", (Object)channelUID, (Object)this.getThing().getUID().getId());
                this.updateChannelState(channelUID);
            }
        }
        catch (Exception ex) {
            this.logger.warn("{}", (Object)ex.getMessage());
        }
    }

    public void handleCommand(ChannelUID channelUID, Command command) {
        this.logger.debug("Received command '{}' for channel '{}'", (Object)command, (Object)channelUID);
        HmDatapoint dp = null;
        try {
            HomematicGateway gateway = this.getHomematicGateway();
            HmDatapointInfo dpInfo = UidUtils.createHmDatapointInfo(channelUID);
            if (RefreshType.REFRESH == command) {
                this.logger.debug("Refreshing {}", (Object)dpInfo);
                dpInfo = new HmDatapointInfo(dpInfo.getAddress(), HmParamsetType.VALUES, 0, "RELOAD_FROM_GATEWAY");
                dp = gateway.getDatapoint(dpInfo);
                this.sendDatapoint(dp, new HmDatapointConfig(), Boolean.TRUE);
            } else {
                Channel channel = this.getThing().getChannel(channelUID.getId());
                if (channel == null) {
                    this.logger.warn("Channel '{}' not found in thing '{}' on gateway '{}'", new Object[]{channelUID, this.getThing().getUID(), gateway.getId()});
                } else if (StopMoveType.STOP == command && "LEVEL".equals(dpInfo.getName())) {
                    dpInfo.setName("STOP");
                    HmDatapoint stopDp = gateway.getDatapoint(dpInfo);
                    ChannelUID stopChannelUID = UidUtils.generateChannelUID(stopDp, this.getThing().getUID());
                    this.handleCommand(stopChannelUID, (Command)OnOffType.ON);
                } else {
                    dp = gateway.getDatapoint(dpInfo);
                    TypeConverter<?> converter = ConverterFactory.createConverter(channel.getAcceptedItemType());
                    Object newValue = converter.convertToBinding((Type)command, dp);
                    HmDatapointConfig config = this.getChannelConfig(channel, dp);
                    this.sendDatapoint(dp, config, newValue);
                }
            }
        }
        catch (GatewayNotAvailableException | HomematicClientException ex) {
            this.logger.warn("{}", (Object)ex.getMessage());
        }
        catch (IOException ex) {
            if (dp != null && dp.getChannel().getDevice().isOffline()) {
                this.logger.warn("Device '{}' is OFFLINE, can't send command '{}' for channel '{}'", new Object[]{dp.getChannel().getDevice().getAddress(), command, channelUID});
                this.logger.trace("{}", (Object)ex.getMessage(), (Object)ex);
            } else {
                this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        catch (ConverterTypeException ex) {
            this.logger.warn("{}, please check the item type and the commands in your scripts", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void sendDatapoint(HmDatapoint dp, HmDatapointConfig config, Object newValue) throws IOException, HomematicClientException, GatewayNotAvailableException {
        String rxMode = this.getRxModeForDatapointTransmission(dp.getName(), dp.getValue(), newValue);
        this.getHomematicGateway().sendDatapoint(dp, config, newValue, rxMode);
    }

    protected String getRxModeForDatapointTransmission(String datapointName, Object currentValue, Object newValue) {
        return null;
    }

    private void updateChannelState(ChannelUID channelUID) throws GatewayNotAvailableException, HomematicClientException, IOException, ConverterException {
        HomematicGateway gateway = this.getHomematicGateway();
        HmDatapointInfo dpInfo = UidUtils.createHmDatapointInfo(channelUID);
        HmDatapoint dp = gateway.getDatapoint(dpInfo);
        Channel channel = this.getThing().getChannel(channelUID.getId());
        this.updateChannelState(dp, channel);
    }

    protected void updateDatapointState(HmDatapoint dp) {
        try {
            this.updateStatus(dp.getChannel().getDevice());
            if (dp.getParamsetType() == HmParamsetType.MASTER) {
                Configuration config = this.editConfiguration();
                config.put(MetadataUtils.getParameterName(dp), dp.isEnumType() ? dp.getOptionValue() : dp.getValue());
                this.updateConfiguration(config);
            } else if (!HomematicTypeGeneratorImpl.isIgnoredDatapoint(dp)) {
                ChannelUID channelUID = UidUtils.generateChannelUID(dp, this.thing.getUID());
                Channel channel = this.thing.getChannel(channelUID.getId());
                if (channel != null) {
                    this.updateChannelState(dp, channel);
                } else {
                    this.logger.warn("Channel not found for datapoint '{}'", (Object)new HmDatapointInfo(dp));
                }
            }
        }
        catch (GatewayNotAvailableException gatewayNotAvailableException) {
        }
        catch (Exception ex) {
            this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    private void updateChannelState(HmDatapoint dp, Channel channel) throws IOException, GatewayNotAvailableException, ConverterException {
        if (dp.isTrigger()) {
            if (dp.getValue() != null) {
                this.triggerChannel(channel.getUID(), ObjectUtils.toString((Object)dp.getValue()));
            }
        } else if (this.isLinked(channel)) {
            this.loadHomematicChannelValues(dp.getChannel());
            TypeConverter<?> converter = ConverterFactory.createConverter(channel.getAcceptedItemType());
            Object state = converter.convertFromBinding(dp);
            if (state != null) {
                this.updateState(channel.getUID(), (State)state);
            } else {
                this.logger.debug("Failed to get converted state from datapoint '{}'", (Object)dp.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHomematicChannelValues(HmChannel hmChannel) throws GatewayNotAvailableException, IOException {
        if (!hmChannel.isInitialized()) {
            HomematicThingHandler homematicThingHandler = this;
            synchronized (homematicThingHandler) {
                if (!hmChannel.isInitialized()) {
                    try {
                        this.getHomematicGateway().loadChannelValues(hmChannel);
                    }
                    catch (IOException ex) {
                        if (hmChannel.getDevice().isOffline()) {
                            this.logger.warn("Device '{}' is OFFLINE, can't update channel '{}'", (Object)hmChannel.getDevice().getAddress(), (Object)hmChannel.getNumber());
                        }
                        throw ex;
                    }
                }
            }
        }
    }

    private void updateStatus(HmDevice device) throws GatewayNotAvailableException, IOException {
        this.loadHomematicChannelValues(device.getChannel(0));
        ThingStatus oldStatus = this.thing.getStatus();
        ThingStatus newStatus = ThingStatus.ONLINE;
        ThingStatusDetail newDetail = ThingStatusDetail.NONE;
        if (this.getBridge().getStatus() == ThingStatus.OFFLINE) {
            newStatus = ThingStatus.OFFLINE;
            newDetail = ThingStatusDetail.BRIDGE_OFFLINE;
        } else if (device.isFirmwareUpdating()) {
            newStatus = ThingStatus.OFFLINE;
            newDetail = ThingStatusDetail.FIRMWARE_UPDATING;
        } else if (device.isUnreach()) {
            newStatus = ThingStatus.OFFLINE;
            newDetail = ThingStatusDetail.COMMUNICATION_ERROR;
        } else if (device.isConfigPending() || device.isUpdatePending()) {
            newDetail = ThingStatusDetail.CONFIGURATION_PENDING;
        }
        if (this.thing.getStatus() != newStatus || this.thing.getStatusInfo().getStatusDetail() != newDetail) {
            this.updateStatus(newStatus, newDetail);
        }
        if (oldStatus == ThingStatus.OFFLINE && newStatus == ThingStatus.ONLINE) {
            this.initialize();
        }
    }

    private boolean isLinked(Channel channel) {
        return channel != null && super.isLinked(channel.getUID().getId());
    }

    protected HmDatapointConfig getChannelConfig(HmDatapoint dp) {
        ChannelUID channelUid = UidUtils.generateChannelUID(dp, this.getThing().getUID());
        Channel channel = this.getThing().getChannel(channelUid.getId());
        return channel != null ? this.getChannelConfig(channel, dp) : new HmDatapointConfig();
    }

    private HmDatapointConfig getChannelConfig(Channel channel, HmDatapoint dp) {
        return (HmDatapointConfig)channel.getConfiguration().as(HmDatapointConfig.class);
    }

    private HomematicGateway getHomematicGateway() throws GatewayNotAvailableException {
        HomematicBridgeHandler bridgeHandler;
        Bridge bridge = this.getBridge();
        if (bridge != null && (bridgeHandler = (HomematicBridgeHandler)bridge.getHandler()) != null && bridgeHandler.getGateway() != null) {
            return bridgeHandler.getGateway();
        }
        throw new GatewayNotAvailableException("HomematicGateway not yet available!");
    }

    public void handleConfigurationUpdate(Map<String, Object> configurationParameters) throws ConfigValidationException {
        super.handleConfigurationUpdate(configurationParameters);
        try {
            HomematicGateway gateway = this.getHomematicGateway();
            HmDevice device = gateway.getDevice(UidUtils.getHomematicAddress(this.getThing()));
            for (Map.Entry<String, Object> configurationParameter : configurationParameters.entrySet()) {
                String key = configurationParameter.getKey();
                Object newValue = configurationParameter.getValue();
                if (!key.startsWith("HMP_")) continue;
                key = StringUtils.removeStart((String)key, (String)"HMP_");
                Integer channelNumber = NumberUtils.toInt((String)StringUtils.substringBefore((String)key, (String)"_"));
                String dpName = StringUtils.substringAfter((String)key, (String)"_");
                HmDatapointInfo dpInfo = new HmDatapointInfo(device.getAddress(), HmParamsetType.MASTER, channelNumber, dpName);
                HmDatapoint dp = device.getChannel(channelNumber).getDatapoint(dpInfo);
                if (dp != null) {
                    try {
                        if (newValue == null) continue;
                        if (newValue instanceof BigDecimal) {
                            BigDecimal decimal = (BigDecimal)newValue;
                            if (dp.isIntegerType()) {
                                newValue = decimal.intValue();
                            } else if (dp.isFloatType()) {
                                newValue = decimal.doubleValue();
                            }
                        }
                        if (!ObjectUtils.notEqual((Object)(dp.isEnumType() ? dp.getOptionValue() : dp.getValue()), (Object)newValue)) continue;
                        this.sendDatapoint(dp, new HmDatapointConfig(), newValue);
                    }
                    catch (IOException ex) {
                        this.logger.error("Error setting thing property {}: {}", (Object)dpInfo, (Object)ex.getMessage());
                    }
                    continue;
                }
                this.logger.error("Can't find datapoint for thing property {}", (Object)dpInfo);
            }
            gateway.triggerDeviceValuesReload(device);
        }
        catch (GatewayNotAvailableException | HomematicClientException ex) {
            this.logger.error("Error setting thing properties: {}", (Object)ex.getMessage(), (Object)ex);
        }
    }

    public synchronized void handleRemoval() {
        boolean unpairOnDeletion;
        BridgeHandler handler;
        Bridge bridge = this.getBridge();
        if (bridge == null || (handler = bridge.getHandler()) == null) {
            super.handleRemoval();
            return;
        }
        HomematicConfig config = (HomematicConfig)bridge.getConfiguration().as(HomematicConfig.class);
        boolean factoryResetOnDeletion = config.isFactoryResetOnDeletion();
        boolean bl = unpairOnDeletion = factoryResetOnDeletion || config.isUnpairOnDeletion();
        if (unpairOnDeletion) {
            this.deviceDeletionPending = true;
            ((HomematicBridgeHandler)handler).deleteFromGateway(UidUtils.getHomematicAddress(this.thing), factoryResetOnDeletion, false, true);
        } else {
            super.handleRemoval();
        }
    }

    public synchronized void deviceRemoved() {
        this.deviceDeletionPending = false;
        if (this.getThing().getStatus() == ThingStatus.REMOVING) {
            this.updateStatus(ThingStatus.REMOVED);
        } else {
            this.updateStatus(ThingStatus.OFFLINE, ThingStatusDetail.GONE);
        }
    }

    public void deviceLoaded(HmDevice device) {
        try {
            this.updateStatus(device);
        }
        catch (GatewayNotAvailableException gatewayNotAvailableException) {
        }
        catch (IOException ex) {
            this.logger.warn("Could not reinitialize the device '{}': {}", new Object[]{device.getAddress(), ex.getMessage(), ex});
        }
    }

    public synchronized boolean isDeletionPending() {
        return this.deviceDeletionPending;
    }
}

