/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.handler;

import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.homematic.HomematicBindingConstants;
import org.eclipse.smarthome.binding.homematic.handler.HomematicBridgeHandler;
import org.eclipse.smarthome.binding.homematic.handler.HomematicThingHandler;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicTypeGenerator;
import org.eclipse.smarthome.core.net.NetworkAddressService;
import org.eclipse.smarthome.core.thing.Bridge;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.binding.BaseThingHandlerFactory;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.eclipse.smarthome.core.thing.binding.ThingHandlerFactory;
import org.eclipse.smarthome.io.net.http.HttpClientFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ThingHandlerFactory.class}, immediate=true, configurationPid="binding.homematic")
public class HomematicThingHandlerFactory
extends BaseThingHandlerFactory {
    private HomematicTypeGenerator typeGenerator;
    private NetworkAddressService networkAddressService;
    private HttpClient httpClient;

    @Reference
    protected void setTypeGenerator(HomematicTypeGenerator typeGenerator) {
        this.typeGenerator = typeGenerator;
    }

    protected void unsetTypeGenerator(HomematicTypeGenerator typeGenerator) {
        this.typeGenerator = null;
    }

    @Reference
    protected void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClient = httpClientFactory.getCommonHttpClient();
    }

    protected void unsetHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClient = null;
    }

    @Reference
    protected void setNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = networkAddressService;
    }

    protected void unsetNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = null;
    }

    public boolean supportsThingType(ThingTypeUID thingTypeUID) {
        return "homematic".equals(thingTypeUID.getBindingId());
    }

    protected ThingHandler createHandler(Thing thing) {
        if (HomematicBindingConstants.THING_TYPE_BRIDGE.equals((Object)thing.getThingTypeUID())) {
            return new HomematicBridgeHandler((Bridge)thing, this.typeGenerator, this.networkAddressService.getPrimaryIpv4HostAddress(), this.httpClient);
        }
        return new HomematicThingHandler(thing);
    }
}

