/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.handler;

import java.util.ArrayList;
import java.util.List;

public class SimplePortPool {
    private static int START_PORT = 9125;
    private List<PortInfo> availablePorts = new ArrayList<PortInfo>();

    public void setInUse(int port) {
        PortInfo portInfo = new PortInfo();
        portInfo.port = port;
        portInfo.free = false;
        this.availablePorts.add(portInfo);
    }

    public synchronized int getNextPort() {
        PortInfo portInfo2;
        for (PortInfo portInfo2 : this.availablePorts) {
            if (!portInfo2.free) continue;
            portInfo2.free = false;
            return portInfo2.port;
        }
        portInfo2 = new PortInfo();
        while (this.isPortInUse(START_PORT++)) {
        }
        portInfo2.port = START_PORT - 1;
        portInfo2.free = false;
        this.availablePorts.add(portInfo2);
        return portInfo2.port;
    }

    private boolean isPortInUse(int port) {
        for (PortInfo portInfo : this.availablePorts) {
            if (portInfo.port != port) continue;
            return !portInfo.free;
        }
        return false;
    }

    public synchronized void release(int port) {
        for (PortInfo portInfo : this.availablePorts) {
            if (portInfo.port != port) continue;
            portInfo.free = true;
        }
    }

    private class PortInfo {
        int port;
        boolean free;

        private PortInfo() {
        }
    }
}

