/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.util.StringContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.AbstractHomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayAdapter;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownParameterSetException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownRpcFailureException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CcuLoadDeviceNamesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CcuParamsetDescriptionParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CcuValueParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CcuVariablesAndScriptsParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmResult;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScript;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataList;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptList;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcuGateway
extends AbstractHomematicGateway {
    private final Logger logger = LoggerFactory.getLogger(CcuGateway.class);
    private Map<String, String> tclregaScripts;
    private XStream xStream = new XStream((HierarchicalStreamDriver)new StaxDriver());

    protected CcuGateway(String id, HomematicConfig config, HomematicGatewayAdapter gatewayAdapter, HttpClient httpClient) {
        super(id, config, gatewayAdapter, httpClient);
        this.xStream.setClassLoader(CcuGateway.class.getClassLoader());
        this.xStream.autodetectAnnotations(true);
        this.xStream.alias("scripts", TclScriptList.class);
        this.xStream.alias("list", TclScriptDataList.class);
        this.xStream.alias("result", HmResult.class);
    }

    @Override
    protected void startClients() throws IOException {
        super.startClients();
        this.tclregaScripts = this.loadTclRegaScripts();
    }

    @Override
    protected void stopClients() {
        super.stopClients();
        this.tclregaScripts = null;
    }

    @Override
    protected void loadVariables(HmChannel channel) throws IOException {
        TclScriptDataList resultList = this.sendScriptByName("getAllVariables", TclScriptDataList.class);
        new CcuVariablesAndScriptsParser(channel).parse(resultList);
    }

    @Override
    protected void loadScripts(HmChannel channel) throws IOException {
        TclScriptDataList resultList = this.sendScriptByName("getAllPrograms", TclScriptDataList.class);
        new CcuVariablesAndScriptsParser(channel).parse(resultList);
    }

    @Override
    protected void loadDeviceNames(Collection<HmDevice> devices) throws IOException {
        TclScriptDataList resultList = this.sendScriptByName("getAllDeviceNames", TclScriptDataList.class);
        new CcuLoadDeviceNamesParser(devices).parse(resultList);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void setChannelDatapointValues(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        block4: {
            try {
                super.setChannelDatapointValues(channel, paramsetType);
                break block4;
            }
            catch (UnknownRpcFailureException v0) {
                this.logger.debug("RpcMessage unknown RPC failure (-1 Failure), fetching values with TclRega script for device {}, channel: {}, paramset: {}", new Object[]{channel.getDevice().getAddress(), channel.getNumber(), paramsetType});
                dpNames = new ArrayList<String>();
                ** for (dp : channel.getDatapoints())
            }
lbl-1000:
            // 1 sources

            {
                if (dp.isVirtual() || !dp.isReadable() || dp.getParamsetType() != HmParamsetType.VALUES) continue;
                dpNames.add(dp.getName());
                continue;
            }
lbl12:
            // 1 sources

            if (dpNames.size() > 0) {
                device = channel.getDevice();
                channelName = String.format("%s.%s:%s.", new Object[]{device.getHmInterface().getName(), device.getAddress(), channel.getNumber()});
                datapointNames = StringUtils.join((Object[])dpNames.toArray(), (String)"\\t");
                resultList = this.sendScriptByName("getAllChannelValues", TclScriptDataList.class, new String[]{"channel_name", "datapoint_names"}, new String[]{channelName, datapointNames});
                new CcuValueParser(channel).parse(resultList);
                channel.setInitialized(true);
            }
        }
    }

    @Override
    protected void addChannelDatapoints(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        try {
            this.getRpcClient(channel.getDevice().getHmInterface()).addChannelDatapoints(channel, paramsetType);
        }
        catch (UnknownParameterSetException unknownParameterSetException) {
            this.logger.debug("RpcMessage RPC failure (-3 Unknown paramset), fetching metadata with TclRega script for device: {}, channel: {}, paramset: {}", new Object[]{channel.getDevice().getAddress(), channel.getNumber(), paramsetType});
            TclScriptDataList resultList = this.sendScriptByName("getParamsetDescription", TclScriptDataList.class, new String[]{"device_address", "channel_number"}, new String[]{channel.getDevice().getAddress(), channel.getNumber().toString()});
            new CcuParamsetDescriptionParser(channel, paramsetType).parse(resultList);
        }
    }

    @Override
    protected void setVariable(HmDatapoint dp, Object value) throws IOException {
        HmResult result;
        String strValue = StringUtils.replace((String)ObjectUtils.toString((Object)value), (String)"\"", (String)"\\\"");
        if (dp.isStringType()) {
            strValue = "\"" + strValue + "\"";
        }
        if (!(result = this.sendScriptByName("setVariable", HmResult.class, new String[]{"variable_name", "variable_state"}, new String[]{dp.getInfo(), strValue})).isValid()) {
            throw new IOException("Unable to set CCU variable " + dp.getInfo());
        }
    }

    @Override
    protected void executeScript(HmDatapoint dp) throws IOException {
        HmResult result = this.sendScriptByName("executeProgram", HmResult.class, new String[]{"program_name"}, new String[]{dp.getInfo()});
        if (!result.isValid()) {
            throw new IOException("Unable to start CCU program: " + dp.getInfo());
        }
    }

    private <T> T sendScriptByName(String scriptName, Class<T> clazz) throws IOException {
        return this.sendScriptByName(scriptName, clazz, new String[0], null);
    }

    private <T> T sendScriptByName(String scriptName, Class<T> clazz, String[] variableNames, String[] values) throws IOException {
        String script = this.tclregaScripts.get(scriptName);
        int i = 0;
        while (i < variableNames.length) {
            script = StringUtils.replace((String)script, (String)("{" + variableNames[i] + "}"), (String)values[i]);
            ++i;
        }
        return this.sendScript(script, clazz);
    }

    private synchronized <T> T sendScript(String script, Class<T> clazz) throws IOException {
        try {
            script = StringUtils.trim((String)script);
            if (StringUtils.isEmpty((String)script)) {
                throw new RuntimeException("Homematic TclRegaScript is empty!");
            }
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("TclRegaScript: {}", (Object)script);
            }
            StringContentProvider content = new StringContentProvider(script, this.config.getEncoding());
            ContentResponse response = this.httpClient.POST(this.config.getTclRegaUrl()).content((ContentProvider)content).timeout((long)this.config.getTimeout(), TimeUnit.SECONDS).header(HttpHeader.CONTENT_TYPE, "text/plain;charset=" + this.config.getEncoding()).send();
            String result = new String(response.getContent(), this.config.getEncoding());
            result = StringUtils.substringBeforeLast((String)result, (String)"<xml><exec>");
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Result TclRegaScript: {}", (Object)result);
            }
            return (T)this.xStream.fromXML(result);
        }
        catch (Exception ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private Map<String, String> loadTclRegaScripts() throws IOException {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream stream = bundle.getResource("homematic/tclrega-scripts.xml").openStream();){
                TclScriptList scriptList = (TclScriptList)this.xStream.fromXML(stream);
                HashMap<String, String> result = new HashMap<String, String>();
                if (scriptList.getScripts() != null) {
                    for (TclScript script : scriptList.getScripts()) {
                        result.put(script.name, StringUtils.trimToNull((String)script.data));
                    }
                }
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalStateException e) {
            throw new IOException("The resource homematic/tclrega-scripts.xml could not be loaded!", e);
        }
    }
}

