/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.AbstractHomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayAdapter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;

public class HomegearGateway
extends AbstractHomematicGateway {
    protected HomegearGateway(String id, HomematicConfig config, HomematicGatewayAdapter gatewayAdapter, HttpClient httpClient) {
        super(id, config, gatewayAdapter, httpClient);
    }

    @Override
    protected void loadVariables(HmChannel channel) throws IOException {
        this.getRpcClient(this.getDefaultInterface()).getAllSystemVariables(channel);
    }

    @Override
    protected void loadScripts(HmChannel channel) throws IOException {
        this.getRpcClient(this.getDefaultInterface()).getAllScripts(channel);
    }

    @Override
    protected void setVariable(HmDatapoint dp, Object value) throws IOException {
        this.getRpcClient(this.getDefaultInterface()).setSystemVariable(dp, value);
    }

    @Override
    protected void executeScript(HmDatapoint dp) throws IOException {
        this.getRpcClient(this.getDefaultInterface()).executeScript(dp);
    }

    @Override
    protected void loadDeviceNames(Collection<HmDevice> devices) throws IOException {
        this.getRpcClient(this.getDefaultInterface()).loadDeviceNames(this.getDefaultInterface(), devices);
    }
}

