/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator;

import java.io.IOException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.CcuGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.DefaultGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomegearGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGateway;
import org.eclipse.smarthome.binding.homematic.internal.communicator.HomematicGatewayAdapter;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.RpcClient;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.XmlRpcClient;

public class HomematicGatewayFactory {
    public static HomematicGateway createGateway(String id, HomematicConfig config, HomematicGatewayAdapter gatewayAdapter, HttpClient httpClient) throws IOException {
        HomematicGatewayFactory.loadGatewayInfo(config, id, httpClient);
        if (config.getGatewayInfo().isCCU()) {
            return new CcuGateway(id, config, gatewayAdapter, httpClient);
        }
        if (config.getGatewayInfo().isHomegear()) {
            return new HomegearGateway(id, config, gatewayAdapter, httpClient);
        }
        return new DefaultGateway(id, config, gatewayAdapter, httpClient);
    }

    private static void loadGatewayInfo(HomematicConfig config, String id, HttpClient httpClient) throws IOException {
        XmlRpcClient rpcClient = new XmlRpcClient(config, httpClient);
        try {
            config.setGatewayInfo(rpcClient.getGatewayInfo(id));
        }
        finally {
            ((RpcClient)rpcClient).dispose();
        }
    }
}

