/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.client;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownRpcFailureException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetAllScriptsParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetAllSystemVariablesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetDeviceDescriptionParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetParamsetDescriptionParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetParamsetParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.GetValueParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.HomegearLoadDeviceNamesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.ListBidcosInterfacesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.ListDevicesParser;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.RssiInfoParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmGatewayInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmRssiInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RpcClient<T> {
    private final Logger logger = LoggerFactory.getLogger(RpcClient.class);
    protected static final int MAX_RPC_RETRY = 1;
    protected HomematicConfig config;

    public RpcClient(HomematicConfig config) {
        this.config = config;
    }

    public abstract void dispose();

    protected abstract RpcRequest<T> createRpcRequest(String var1);

    protected abstract String getRpcCallbackUrl();

    protected abstract Object[] sendMessage(int var1, RpcRequest<T> var2) throws IOException;

    public void init(HmInterface hmInterface, String clientId) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("init");
        request.addArg(this.getRpcCallbackUrl());
        request.addArg(clientId);
        if (this.config.getGatewayInfo().isHomegear()) {
            request.addArg(new Integer(34));
        }
        this.sendMessage(this.config.getRpcPort(hmInterface), request);
    }

    public void release(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("init");
        request.addArg(this.getRpcCallbackUrl());
        this.sendMessage(this.config.getRpcPort(hmInterface), request);
    }

    public void ping(HmInterface hmInterface, String callerId) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("ping");
        request.addArg(callerId);
        this.sendMessage(this.config.getRpcPort(hmInterface), request);
    }

    public ListBidcosInterfacesParser listBidcosInterfaces(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("listBidcosInterfaces");
        return new ListBidcosInterfacesParser().parse(this.sendMessage(this.config.getRpcPort(hmInterface), request));
    }

    private GetDeviceDescriptionParser getDeviceDescription(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("getDeviceDescription");
        request.addArg("BidCoS-RF");
        return new GetDeviceDescriptionParser().parse(this.sendMessage(this.config.getRpcPort(hmInterface), request));
    }

    public void getAllSystemVariables(HmChannel channel) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("getAllSystemVariables");
        new GetAllSystemVariablesParser(channel).parse(this.sendMessage(this.config.getRpcPort(channel), request));
    }

    public void loadDeviceNames(HmInterface hmInterface, Collection<HmDevice> devices) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("getDeviceInfo");
        new HomegearLoadDeviceNamesParser(devices).parse(this.sendMessage(this.config.getRpcPort(hmInterface), request));
    }

    public void checkInterface(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("init");
        request.addArg("http://openhab.validation:1000");
        this.sendMessage(this.config.getRpcPort(hmInterface), request);
    }

    public void getAllScripts(HmChannel channel) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("getAllScripts");
        new GetAllScriptsParser(channel).parse(this.sendMessage(this.config.getRpcPort(channel), request));
    }

    public Collection<HmDevice> listDevices(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("listDevices");
        return new ListDevicesParser(hmInterface, this.config).parse(this.sendMessage(this.config.getRpcPort(hmInterface), request));
    }

    public void addChannelDatapoints(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        if (this.isConfigurationChannel(channel) && paramsetType != HmParamsetType.MASTER) {
            return;
        }
        RpcRequest<T> request = this.createRpcRequest("getParamsetDescription");
        request.addArg(String.valueOf(this.getRpcAddress(channel.getDevice().getAddress())) + this.getChannelSuffix(channel));
        request.addArg(paramsetType.toString());
        new GetParamsetDescriptionParser(channel, paramsetType).parse(this.sendMessage(this.config.getRpcPort(channel), request));
    }

    public void setChannelDatapointValues(HmChannel channel, HmParamsetType paramsetType) throws IOException {
        if (this.isConfigurationChannel(channel) && paramsetType != HmParamsetType.MASTER) {
            return;
        }
        RpcRequest<T> request = this.createRpcRequest("getParamset");
        request.addArg(String.valueOf(this.getRpcAddress(channel.getDevice().getAddress())) + this.getChannelSuffix(channel));
        request.addArg(paramsetType.toString());
        if (channel.getDevice().getHmInterface() == HmInterface.CUXD && paramsetType == HmParamsetType.VALUES) {
            this.setChannelDatapointValues(channel);
        } else {
            try {
                new GetParamsetParser(channel, paramsetType).parse(this.sendMessage(this.config.getRpcPort(channel), request));
            }
            catch (UnknownRpcFailureException ex) {
                if (paramsetType == HmParamsetType.VALUES) {
                    this.logger.debug("RpcResponse unknown RPC failure (-1 Failure), fetching values with another API method for device: {}, channel: {}, paramset: {}", new Object[]{channel.getDevice().getAddress(), channel.getNumber(), paramsetType});
                    this.setChannelDatapointValues(channel);
                }
                throw ex;
            }
        }
    }

    private void setChannelDatapointValues(HmChannel channel) throws IOException {
        for (HmDatapoint dp : channel.getDatapoints()) {
            this.getDatapointValue(dp);
        }
    }

    public HmGatewayInfo getGatewayInfo(String id) throws IOException {
        ListBidcosInterfacesParser biParser;
        GetDeviceDescriptionParser ddParser;
        boolean isHomegear = false;
        try {
            ddParser = this.getDeviceDescription(HmInterface.RF);
            isHomegear = StringUtils.equalsIgnoreCase((String)ddParser.getType(), (String)"Homegear");
        }
        catch (IOException iOException) {
            ddParser = new GetDeviceDescriptionParser();
        }
        try {
            biParser = this.listBidcosInterfaces(HmInterface.RF);
        }
        catch (IOException iOException) {
            biParser = this.listBidcosInterfaces(HmInterface.HMIP);
        }
        HmGatewayInfo gatewayInfo = new HmGatewayInfo();
        gatewayInfo.setAddress(biParser.getGatewayAddress());
        if (isHomegear) {
            gatewayInfo.setId("HOMEGEAR");
            gatewayInfo.setType(ddParser.getType());
            gatewayInfo.setFirmware(ddParser.getFirmware());
        } else if ((StringUtils.startsWithIgnoreCase((String)biParser.getType(), (String)"CCU") || StringUtils.startsWithIgnoreCase((String)biParser.getType(), (String)"HMIP_CCU") || StringUtils.startsWithIgnoreCase((String)ddParser.getType(), (String)"HM-RCV-50") || this.config.isCCUType()) && !this.config.isNoCCUType()) {
            gatewayInfo.setId("CCU");
            String type = StringUtils.isBlank((String)biParser.getType()) ? "CCU" : biParser.getType();
            gatewayInfo.setType(type);
            gatewayInfo.setFirmware(ddParser.getFirmware() != null ? ddParser.getFirmware() : biParser.getFirmware());
        } else {
            gatewayInfo.setId("DEFAULT");
            gatewayInfo.setType(biParser.getType());
            gatewayInfo.setFirmware(biParser.getFirmware());
        }
        if (gatewayInfo.isCCU() || this.config.hasRfPort()) {
            gatewayInfo.setRfInterface(this.hasInterface(HmInterface.RF, id));
        }
        if (gatewayInfo.isCCU() || this.config.hasWiredPort()) {
            gatewayInfo.setWiredInterface(this.hasInterface(HmInterface.WIRED, id));
        }
        if (gatewayInfo.isCCU() || this.config.hasHmIpPort()) {
            gatewayInfo.setHmipInterface(this.hasInterface(HmInterface.HMIP, id));
        }
        if (gatewayInfo.isCCU() || this.config.hasCuxdPort()) {
            gatewayInfo.setCuxdInterface(this.hasInterface(HmInterface.CUXD, id));
        }
        if (gatewayInfo.isCCU() || this.config.hasGroupPort()) {
            gatewayInfo.setGroupInterface(this.hasInterface(HmInterface.GROUP, id));
        }
        return gatewayInfo;
    }

    private boolean hasInterface(HmInterface hmInterface, String id) throws IOException {
        try {
            this.checkInterface(hmInterface);
            return true;
        }
        catch (IOException iOException) {
            this.logger.info("Interface '{}' on gateway '{}' not available, disabling support", (Object)hmInterface, (Object)id);
            return false;
        }
    }

    public void setDatapointValue(HmDatapoint dp, Object value, String rxMode) throws IOException {
        RpcRequest<T> request;
        if (dp.isIntegerType() && value instanceof Double) {
            value = ((Number)value).intValue();
        }
        if (HmParamsetType.VALUES == dp.getParamsetType()) {
            request = this.createRpcRequest("setValue");
            request.addArg(String.valueOf(this.getRpcAddress(dp.getChannel().getDevice().getAddress())) + this.getChannelSuffix(dp.getChannel()));
            request.addArg(dp.getName());
            request.addArg(value);
            this.configureRxMode(request, rxMode);
        } else {
            request = this.createRpcRequest("putParamset");
            request.addArg(String.valueOf(this.getRpcAddress(dp.getChannel().getDevice().getAddress())) + this.getChannelSuffix(dp.getChannel()));
            request.addArg(HmParamsetType.MASTER.toString());
            HashMap<String, Object> paramSet = new HashMap<String, Object>();
            paramSet.put(dp.getName(), value);
            request.addArg(paramSet);
            this.configureRxMode(request, rxMode);
        }
        this.sendMessage(this.config.getRpcPort(dp.getChannel()), request);
    }

    protected void configureRxMode(RpcRequest<T> request, String rxMode) {
        if (rxMode != null && ("BURST".equals(rxMode) || "WAKEUP".equals(rxMode))) {
            request.addArg(rxMode);
        }
    }

    public void getDatapointValue(HmDatapoint dp) throws IOException {
        if (dp.isReadable() && !dp.isVirtual() && dp.getParamsetType() == HmParamsetType.VALUES) {
            RpcRequest<T> request = this.createRpcRequest("getValue");
            request.addArg(String.valueOf(this.getRpcAddress(dp.getChannel().getDevice().getAddress())) + this.getChannelSuffix(dp.getChannel()));
            request.addArg(dp.getName());
            new GetValueParser(dp).parse(this.sendMessage(this.config.getRpcPort(dp.getChannel()), request));
        }
    }

    public void setSystemVariable(HmDatapoint dp, Object value) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("setSystemVariable");
        request.addArg(dp.getInfo());
        request.addArg(value);
        this.sendMessage(this.config.getRpcPort(dp.getChannel()), request);
    }

    public void executeScript(HmDatapoint dp) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("runScript");
        request.addArg(dp.getInfo());
        this.sendMessage(this.config.getRpcPort(dp.getChannel()), request);
    }

    public void setInstallMode(HmInterface hmInterface, boolean enable, int seconds) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("setInstallMode");
        request.addArg(enable);
        request.addArg(seconds);
        request.addArg(1);
        this.logger.debug("Submitting setInstallMode(on={}, time={}, mode={}) ", new Object[]{enable, seconds, 1});
        this.sendMessage(this.config.getRpcPort(hmInterface), request);
    }

    public int getInstallMode(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("getInstallMode");
        Object[] result = this.sendMessage(this.config.getRpcPort(hmInterface), request);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Checking InstallMode: getInstallMode() request returned {} (remaining seconds in InstallMode=true)", result);
        }
        try {
            return (Integer)result[0];
        }
        catch (Exception cause) {
            IOException wrappedException = new IOException("Failed to request install mode from interface " + (Object)((Object)hmInterface));
            wrappedException.initCause(cause);
            throw wrappedException;
        }
    }

    public void deleteDevice(HmDevice device, int flags) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("deleteDevice");
        request.addArg(device.getAddress());
        request.addArg(flags);
        this.sendMessage(this.config.getRpcPort(device.getHmInterface()), request);
    }

    private String getRpcAddress(String address) {
        if (address != null && address.startsWith("T-")) {
            address = "*" + address.substring(2);
        }
        return address;
    }

    public List<HmRssiInfo> loadRssiInfo(HmInterface hmInterface) throws IOException {
        RpcRequest<T> request = this.createRpcRequest("rssiInfo");
        return new RssiInfoParser(this.config).parse(this.sendMessage(this.config.getRpcPort(hmInterface), request));
    }

    private String getChannelSuffix(HmChannel channel) {
        return this.isConfigurationChannel(channel) ? "" : ":" + channel.getNumber();
    }

    private boolean isConfigurationChannel(HmChannel channel) {
        return channel.getNumber() == -1;
    }
}

