/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.message;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcResponse;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinRpcMessage
implements RpcRequest<byte[]>,
RpcResponse {
    private final Logger logger = LoggerFactory.getLogger(BinRpcMessage.class);
    private Object[] messageData;
    private byte[] binRpcData;
    private int offset;
    private String methodName;
    private TYPE type;
    private int args;
    private String encoding;

    public BinRpcMessage(String methodName, String encoding) {
        this(methodName, TYPE.REQUEST, encoding);
    }

    public BinRpcMessage(String methodName, TYPE type, String encoding) {
        this.methodName = methodName;
        this.type = type;
        this.encoding = encoding;
        this.createHeader();
    }

    public BinRpcMessage(InputStream is, boolean methodHeader, String encoding) throws IOException {
        int currentLength;
        this.encoding = encoding;
        byte[] sig = new byte[8];
        int length = is.read(sig, 0, 4);
        if (length != 4) {
            throw new EOFException("Only " + length + " bytes received reading signature");
        }
        this.validateBinXSignature(sig);
        length = is.read(sig, 4, 4);
        if (length != 4) {
            throw new EOFException("Only " + length + " bytes received reading message length");
        }
        int datasize = new BigInteger(ArrayUtils.subarray((byte[])sig, (int)4, (int)8)).intValue();
        byte[] payload = new byte[datasize];
        int offset = 0;
        while (offset < datasize && (currentLength = is.read(payload, offset, datasize - offset)) != -1) {
            offset += currentLength;
        }
        if (offset != datasize) {
            throw new EOFException("Only " + offset + " bytes received while reading message payload, expected " + datasize + " bytes");
        }
        byte[] message = ArrayUtils.addAll((byte[])sig, (byte[])payload);
        this.decodeMessage(message, methodHeader);
    }

    private void validateBinXSignature(byte[] sig) throws UnsupportedEncodingException {
        if (sig[0] != 66 || sig[1] != 105 || sig[2] != 110) {
            throw new UnsupportedEncodingException("No BinX signature");
        }
    }

    public BinRpcMessage(byte[] message, boolean methodHeader, String encoding) throws IOException, ParseException {
        this.encoding = encoding;
        if (message.length < 8) {
            throw new EOFException("Only " + message.length + " bytes received");
        }
        this.validateBinXSignature(message);
        this.decodeMessage(message, methodHeader);
    }

    private void decodeMessage(byte[] message, boolean methodHeader) throws IOException {
        this.binRpcData = message;
        this.offset = 8;
        if (methodHeader) {
            this.methodName = this.readString();
            this.readInt();
        }
        this.generateResponseData();
    }

    public void setType(TYPE type) {
        this.binRpcData[3] = type == TYPE.RESPONSE ? (byte)1 : 0;
    }

    private void generateResponseData() throws IOException {
        this.offset = 8 + (this.methodName != null ? this.methodName.length() + 8 : 0);
        ArrayList<Object> values = new ArrayList<Object>();
        while (this.offset < this.binRpcData.length) {
            values.add(this.readRpcValue());
        }
        this.messageData = values.toArray();
        values.clear();
    }

    private void createHeader() {
        this.binRpcData = new byte[256];
        this.addString("Bin ");
        this.setType(this.type);
        this.addInt(0);
        if (this.methodName != null) {
            this.addInt(this.methodName.length());
            this.addString(this.methodName);
            this.addInt(0);
        }
        this.setInt(4, this.offset - 8);
    }

    @Override
    public void addArg(Object argument) {
        this.addObject(argument);
        this.setInt(4, this.offset - 8);
        if (this.methodName != null) {
            this.setInt(12 + this.methodName.length(), ++this.args);
        }
    }

    public int getArgCount() {
        return this.args;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public byte[] createMessage() {
        this.trimBinRpcData();
        return this.binRpcData;
    }

    private void trimBinRpcData() {
        byte[] trimmed = new byte[this.offset];
        System.arraycopy(this.binRpcData, 0, trimmed, 0, this.offset);
        this.binRpcData = trimmed;
    }

    @Override
    public Object[] getResponseData() {
        return this.messageData;
    }

    private int readInt() {
        byte[] bi = new byte[4];
        System.arraycopy(this.binRpcData, this.offset, bi, 0, 4);
        this.offset += 4;
        return new BigInteger(bi).intValue();
    }

    private String readString() throws UnsupportedEncodingException {
        int len = this.readInt();
        this.offset += len;
        return new String(this.binRpcData, this.offset - len, len, this.encoding);
    }

    private Object readRpcValue() throws IOException {
        int type = this.readInt();
        switch (type) {
            case 1: {
                return new Integer(this.readInt());
            }
            case 2: {
                return this.binRpcData[this.offset++] != 0 ? Boolean.TRUE : Boolean.FALSE;
            }
            case 3: {
                return this.readString();
            }
            case 4: {
                int mantissa = this.readInt();
                int exponent = this.readInt();
                BigDecimal bd = new BigDecimal((double)mantissa / 1.073741824E9 * Math.pow(2.0, exponent));
                return bd.setScale(6, RoundingMode.HALF_DOWN).doubleValue();
            }
            case 5: {
                return new Date(this.readInt() * 1000);
            }
            case 256: {
                int numElements = this.readInt();
                ArrayList<Object> array = new ArrayList<Object>();
                while (numElements-- > 0) {
                    array.add(this.readRpcValue());
                }
                return array.toArray();
            }
            case 257: {
                int numElements = this.readInt();
                TreeMap<String, Object> struct = new TreeMap<String, Object>();
                while (numElements-- > 0) {
                    String name = this.readString();
                    struct.put(name, this.readRpcValue());
                }
                return struct;
            }
        }
        int i = 0;
        while (i < this.binRpcData.length) {
            this.logger.info("{} {}", (Object)Integer.toHexString(this.binRpcData[i]), (Object)Character.valueOf((char)this.binRpcData[i]));
            ++i;
        }
        throw new IOException("Unknown data type " + type);
    }

    private void setInt(int position, int value) {
        int temp = this.offset;
        this.offset = position;
        this.addInt(value);
        this.offset = temp;
    }

    private void addByte(byte b) {
        if (this.offset == this.binRpcData.length) {
            byte[] newdata = new byte[this.binRpcData.length * 2];
            System.arraycopy(this.binRpcData, 0, newdata, 0, this.binRpcData.length);
            this.binRpcData = newdata;
        }
        this.binRpcData[this.offset++] = b;
    }

    private void addInt(int value) {
        this.addByte((byte)(value >> 24));
        this.addByte((byte)(value >> 16));
        this.addByte((byte)(value >> 8));
        this.addByte((byte)value);
    }

    /*
     * Unable to fully structure code
     */
    private void addDouble(double value) {
        block3: {
            tmp = Math.abs(value);
            exp = 0;
            if (tmp == 0.0 || !(tmp < 0.5)) ** GOTO lbl11
            while (tmp < 0.5) {
                tmp *= 2.0;
                --exp;
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                tmp /= 2.0;
                ++exp;
lbl11:
                // 2 sources

                ** while (tmp >= 1.0)
            }
        }
        if (value < 0.0) {
            tmp *= -1.0;
        }
        mantissa = (int)Math.round(tmp * 1.073741824E9);
        this.addInt(mantissa);
        this.addInt(exp);
    }

    private void addString(String string) {
        byte[] sd;
        try {
            sd = string.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            sd = string.getBytes();
        }
        byte[] byArray = sd;
        int n = sd.length;
        int n2 = 0;
        while (n2 < n) {
            byte ch = byArray[n2];
            this.addByte(ch);
            ++n2;
        }
    }

    private void addList(Collection<?> collection) {
        for (Object object : collection) {
            this.addObject(object);
        }
    }

    private void addObject(Object object) {
        if (object.getClass() == String.class) {
            this.addInt(3);
            String string = (String)object;
            this.addInt(string.length());
            this.addString(string);
        } else if (object.getClass() == Boolean.class) {
            this.addInt(2);
            this.addByte((Boolean)object != false ? (byte)1 : 0);
        } else if (object.getClass() == Integer.class) {
            this.addInt(1);
            this.addInt((Integer)object);
        } else if (object.getClass() == Double.class) {
            this.addInt(4);
            this.addDouble((Double)object);
        } else if (object.getClass() == Float.class) {
            this.addInt(4);
            BigDecimal bd = new BigDecimal(((Float)object).floatValue());
            this.addDouble(bd.setScale(6, RoundingMode.HALF_DOWN).doubleValue());
        } else if (object.getClass() == BigDecimal.class) {
            this.addInt(4);
            this.addDouble(((BigDecimal)object).setScale(6, RoundingMode.HALF_DOWN).doubleValue());
        } else if (object.getClass() == BigInteger.class) {
            this.addInt(4);
            this.addDouble(((BigInteger)object).doubleValue());
        } else if (object.getClass() == Date.class) {
            this.addInt(5);
            this.addInt((int)((Date)object).getTime() / 1000);
        } else if (object instanceof List) {
            Collection list = (Collection)object;
            this.addInt(256);
            this.addInt(list.size());
            this.addList(list);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.addInt(257);
            this.addInt(map.size());
            for (Map.Entry entry : map.entrySet()) {
                String key = (String)entry.getKey();
                if (key == null) continue;
                this.addInt(key.length());
                this.addString(key);
                this.addList(Collections.singleton(entry.getValue()));
            }
        }
    }

    public String toBinString() {
        return Arrays.toString(this.createMessage());
    }

    public String toString() {
        try {
            this.trimBinRpcData();
            this.generateResponseData();
            return RpcUtils.dumpRpcMessage(this.methodName, this.messageData);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static enum TYPE {
        REQUEST,
        RESPONSE;

    }
}

