/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.message;

import java.util.Map;

public class RpcUtils {
    public static String dumpRpcMessage(String methodName, Object[] responseData) {
        StringBuilder sb = new StringBuilder();
        if (methodName != null) {
            sb.append(methodName);
            sb.append("()\n");
        }
        RpcUtils.dumpCollection(responseData, sb, 0);
        return sb.toString();
    }

    private static void dumpCollection(Object[] c, StringBuilder sb, int indent) {
        if (indent > 0) {
            int in = 0;
            while (in < indent - 1) {
                sb.append('\t');
                ++in;
            }
            sb.append("[\n");
        }
        Object[] objectArray = c;
        int n = c.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof Map) {
                RpcUtils.dumpMap((Map)o, sb, indent + 1);
            } else if (o instanceof Object[]) {
                RpcUtils.dumpCollection((Object[])o, sb, indent + 1);
            } else {
                int in = 0;
                while (in < indent) {
                    sb.append('\t');
                    ++in;
                }
                sb.append(o);
                sb.append('\n');
            }
            ++n2;
        }
        if (indent > 0) {
            int in = 0;
            while (in < indent - 1) {
                sb.append('\t');
                ++in;
            }
            sb.append("]\n");
        }
    }

    private static void dumpMap(Map<?, ?> c, StringBuilder sb, int indent) {
        if (indent > 0) {
            int in = 0;
            while (in < indent - 1) {
                sb.append('\t');
                ++in;
            }
            sb.append("{\n");
        }
        for (Map.Entry<?, ?> me : c.entrySet()) {
            Object o = me.getValue();
            int in = 0;
            while (in < indent) {
                sb.append('\t');
                ++in;
            }
            sb.append(me.getKey());
            sb.append('=');
            if (o instanceof Map) {
                sb.append("\n");
                RpcUtils.dumpMap((Map)o, sb, indent + 1);
                continue;
            }
            if (o instanceof Object[]) {
                sb.append("\n");
                RpcUtils.dumpCollection((Object[])o, sb, indent + 1);
                continue;
            }
            sb.append(o);
            sb.append('\n');
        }
        if (indent > 0) {
            int in = 0;
            while (in < indent - 1) {
                sb.append('\t');
                ++in;
            }
            sb.append("}\n");
        }
    }
}

