/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.message;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcResponse;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.XmlRpcRequest;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlRpcResponse
implements RpcResponse {
    private String methodName;
    private Object[] responseData;

    public XmlRpcResponse(InputStream is, String encoding) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser saxParser = factory.newSAXParser();
        InputSource inputSource = new InputSource(is);
        inputSource.setEncoding(encoding);
        saxParser.parse(inputSource, (DefaultHandler)new XmlRpcHandler());
    }

    @Override
    public Object[] getResponseData() {
        return this.responseData;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return RpcUtils.dumpRpcMessage(this.methodName, this.responseData);
    }

    private class XmlRpcHandler
    extends DefaultHandler {
        private List<Object> result = new ArrayList<Object>();
        private LinkedList<List<Object>> currentDataObject = new LinkedList();
        private StringBuilder tagValue;
        private boolean isValueTag;

        private XmlRpcHandler() {
        }

        @Override
        public void startDocument() throws SAXException {
            this.currentDataObject.addLast(new ArrayList());
        }

        @Override
        public void endDocument() throws SAXException {
            this.result.addAll((Collection<Object>)this.currentDataObject.removeLast());
            XmlRpcResponse.this.responseData = this.result.toArray();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String tag = qName.toLowerCase();
            if (tag.equals("array") || tag.equals("struct")) {
                this.currentDataObject.addLast(new ArrayList());
            }
            this.isValueTag = tag.equals("value");
            this.tagValue = new StringBuilder();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String currentTag = qName.toLowerCase();
            String currentValue = this.tagValue.toString();
            List<Object> data = this.currentDataObject.peekLast();
            switch (currentTag) {
                case "boolean": {
                    data.add("1".equals(currentValue) ? Boolean.TRUE : Boolean.FALSE);
                    break;
                }
                case "i4": 
                case "int": {
                    data.add(new Integer(currentValue));
                    break;
                }
                case "double": {
                    data.add(new Double(currentValue));
                    break;
                }
                case "string": 
                case "name": {
                    data.add(currentValue);
                    break;
                }
                case "value": {
                    if (!this.isValueTag) break;
                    data.add(currentValue);
                    this.isValueTag = false;
                    break;
                }
                case "array": {
                    List<Object> arrayData = this.currentDataObject.removeLast();
                    this.currentDataObject.peekLast().add(arrayData.toArray());
                    break;
                }
                case "struct": {
                    List<Object> mapData = this.currentDataObject.removeLast();
                    HashMap<Object, Object> resultMap = new HashMap<Object, Object>();
                    int i = 0;
                    while (i < mapData.size()) {
                        resultMap.put(mapData.get(i), mapData.get(i + 1));
                        i += 2;
                    }
                    this.currentDataObject.peekLast().add(resultMap);
                    break;
                }
                case "base64": {
                    data.add(Base64.getDecoder().decode(currentValue));
                    break;
                }
                case "datetime.iso8601": {
                    try {
                        data.add(XmlRpcRequest.xmlRpcDateFormat.parse(currentValue));
                        break;
                    }
                    catch (ParseException ex) {
                        throw new SAXException(ex.getMessage(), ex);
                    }
                }
                case "methodname": {
                    XmlRpcResponse.this.methodName = currentValue;
                    break;
                }
                default: {
                    throw new SAXException("Unknown XML-RPC tag: " + currentTag);
                }
                case "member": 
                case "params": 
                case "methodcall": 
                case "data": 
                case "methodresponse": 
                case "fault": 
                case "param": 
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.tagValue.append(new String(ch, start, length));
        }
    }
}

