/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataEntry;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataList;

public class CcuLoadDeviceNamesParser
extends CommonRpcParser<TclScriptDataList, Void> {
    private Collection<HmDevice> devices;

    public CcuLoadDeviceNamesParser(Collection<HmDevice> devices) {
        this.devices = devices;
    }

    @Override
    public Void parse(TclScriptDataList resultList) throws IOException {
        if (resultList.getEntries() != null) {
            HashMap<String, HmDevice> devicesByAddress = new HashMap<String, HmDevice>();
            for (HmDevice device : this.devices) {
                devicesByAddress.put(device.getAddress(), device);
            }
            for (TclScriptDataEntry entry : resultList.getEntries()) {
                HmDevice device = (HmDevice)devicesByAddress.get(this.getSanitizedAddress(entry.name));
                if (device == null) continue;
                device.setName(entry.value);
            }
        }
        return null;
    }
}

