/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataEntry;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataList;

public class CcuParamsetDescriptionParser
extends CommonRpcParser<TclScriptDataList, Void> {
    private HmParamsetType paramsetType;
    private HmChannel channel;
    private boolean isHmIpDevice;

    public CcuParamsetDescriptionParser(HmChannel channel, HmParamsetType paramsetType) {
        this.channel = channel;
        this.paramsetType = paramsetType;
        this.isHmIpDevice = channel.getDevice().getHmInterface() == HmInterface.HMIP;
    }

    @Override
    public Void parse(TclScriptDataList resultList) throws IOException {
        if (resultList.getEntries() != null) {
            for (TclScriptDataEntry entry : resultList.getEntries()) {
                HmDatapoint dp = this.assembleDatapoint(entry.name, entry.unit, entry.valueType, this.toOptionList(entry.options), this.convertToType(entry.minValue), this.convertToType(entry.maxValue), this.toInteger(entry.operations), this.convertToType(entry.value), this.paramsetType, this.isHmIpDevice);
                this.channel.addDatapoint(dp);
            }
        }
        return null;
    }

    private String[] toOptionList(String options) {
        String[] result = StringUtils.splitByWholeSeparatorPreserveAllTokens((String)options, (String)";");
        return result == null || result.length == 0 ? null : result;
    }
}

