/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataEntry;
import org.eclipse.smarthome.binding.homematic.internal.model.TclScriptDataList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CcuValueParser
extends CommonRpcParser<TclScriptDataList, Void> {
    private final Logger logger = LoggerFactory.getLogger(CcuValueParser.class);
    private HmChannel channel;

    public CcuValueParser(HmChannel channel) {
        this.channel = channel;
    }

    @Override
    public Void parse(TclScriptDataList resultList) throws IOException {
        if (resultList.getEntries() != null) {
            for (TclScriptDataEntry entry : resultList.getEntries()) {
                HmDatapointInfo dpInfo = HmDatapointInfo.createValuesInfo(this.channel, entry.name);
                HmDatapoint dp = this.channel.getDatapoint(dpInfo);
                if (dp != null) {
                    dp.setValue(this.convertToType(dp, entry.value));
                    this.adjustRssiValue(dp);
                    continue;
                }
                this.logger.warn("Can't set value for datapoint '{}'", (Object)dpInfo);
            }
        }
        return null;
    }
}

