/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.RpcParser;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonRpcParser<M, R>
implements RpcParser<M, R> {
    private final Logger logger = LoggerFactory.getLogger(CommonRpcParser.class);

    protected String toString(Object object) {
        return StringUtils.trimToNull((String)ObjectUtils.toString((Object)object));
    }

    protected Integer toInteger(Object object) {
        if (object == null || object instanceof Integer) {
            return (Integer)object;
        }
        try {
            return Double.valueOf(ObjectUtils.toString((Object)object)).intValue();
        }
        catch (NumberFormatException ex) {
            this.logger.debug("Failed converting {} to a Double", object, (Object)ex);
            return null;
        }
    }

    protected Double toDouble(Object object) {
        if (object == null || object instanceof Double) {
            return (Double)object;
        }
        try {
            return Double.valueOf(ObjectUtils.toString((Object)object));
        }
        catch (NumberFormatException ex) {
            this.logger.debug("Failed converting {} to a Double", object, (Object)ex);
            return null;
        }
    }

    protected Number toNumber(Object object) {
        if (object == null || object instanceof Number) {
            return (Number)object;
        }
        try {
            return NumberUtils.createNumber((String)ObjectUtils.toString((Object)object));
        }
        catch (NumberFormatException ex) {
            this.logger.debug("Failed converting {} to a Number", object, (Object)ex);
            return null;
        }
    }

    protected Boolean toBoolean(Object object) {
        if (object == null || object instanceof Boolean) {
            return (Boolean)object;
        }
        return BooleanUtils.toBoolean((String)ObjectUtils.toString((Object)object));
    }

    protected String[] toOptionList(Object optionList) {
        if (optionList != null && optionList instanceof Object[]) {
            Object[] vl = (Object[])optionList;
            String[] stringArray = new String[vl.length];
            int i = 0;
            while (i < vl.length) {
                stringArray[i] = vl[i].toString();
                ++i;
            }
            return stringArray;
        }
        return null;
    }

    protected String getSanitizedAddress(Object object) {
        String address = StringUtils.trimToNull((String)StringUtils.replaceOnce((String)this.toString(object), (String)"*", (String)"T-"));
        return MiscUtils.validateCharacters(address, "Address", "_");
    }

    protected void adjustRssiValue(HmDatapoint dp) {
        if (dp.getValue() != null && dp.getName().startsWith("RSSI_") && dp.isIntegerType()) {
            int rssiValue = ((Number)dp.getValue()).intValue();
            dp.setValue(this.getAdjustedRssiValue(rssiValue));
        }
    }

    protected Integer getAdjustedRssiValue(Integer rssiValue) {
        if (rssiValue == null || rssiValue >= 255 || rssiValue <= -255) {
            return 0;
        }
        return rssiValue;
    }

    protected Object convertToType(HmDatapoint dp, Object value) {
        if (value == null) {
            return null;
        }
        if (dp.isBooleanType()) {
            return this.toBoolean(value);
        }
        if (dp.isIntegerType()) {
            return this.toInteger(value);
        }
        if (dp.isFloatType()) {
            return this.toNumber(value);
        }
        if (dp.isStringType()) {
            return this.toString(value);
        }
        return value;
    }

    protected HmDatapoint assembleDatapoint(String name, String unit, String type, String[] options, Object min, Object max, Integer operations, Object defaultValue, HmParamsetType paramsetType, boolean isHmIpDevice) throws IOException {
        HmValueType valueType;
        HmDatapoint dp = new HmDatapoint();
        dp.setName(name);
        dp.setDescription(name);
        dp.setUnit(StringUtils.replace((String)StringUtils.trimToNull((String)unit), (String)"\ufffd", (String)"\u00b0"));
        if (dp.getUnit() == null && StringUtils.startsWith((String)dp.getName(), (String)"RSSI_")) {
            dp.setUnit("dBm");
        }
        if ((valueType = HmValueType.parse(type)) == null || valueType == HmValueType.UNKNOWN) {
            throw new IOException("Unknown datapoint type: " + type);
        }
        dp.setType(valueType);
        dp.setOptions(options);
        if (dp.isNumberType() || dp.isEnumType()) {
            if (isHmIpDevice && dp.isEnumType()) {
                dp.setMinValue(dp.getOptionIndex(this.toString(min)));
                dp.setMaxValue(dp.getOptionIndex(this.toString(max)));
            } else {
                dp.setMinValue(this.toNumber(min));
                dp.setMaxValue(this.toNumber(max));
            }
        }
        dp.setReadOnly((operations & 2) != 2);
        dp.setReadable((operations & 1) == 1);
        dp.setParamsetType(paramsetType);
        if (isHmIpDevice && dp.isEnumType()) {
            dp.setDefaultValue(dp.getOptionIndex(this.toString(defaultValue)));
        } else {
            dp.setDefaultValue(this.convertToType(dp, defaultValue));
        }
        dp.setValue(dp.getDefaultValue());
        return dp;
    }

    protected Object convertToType(String value) {
        if (StringUtils.isBlank((String)value)) {
            return null;
        }
        if (value.equalsIgnoreCase("true") || value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false") || value.equalsIgnoreCase("off")) {
            return Boolean.FALSE;
        }
        if (value.matches("(-|\\+)?[0-9]+")) {
            return Integer.valueOf(value);
        }
        if (value.matches("[-+]?[0-9]*\\.?[0-9]+([eE][-+]?[0-9]+)?")) {
            return Double.valueOf(value);
        }
        return value;
    }
}

