/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class GetAllSystemVariablesParser
extends CommonRpcParser<Object[], Void> {
    private HmChannel channel;

    public GetAllSystemVariablesParser(HmChannel channel) {
        this.channel = channel;
    }

    @Override
    public Void parse(Object[] message) throws IOException {
        Map mapMessage = (Map)message[0];
        for (String variableName : mapMessage.keySet()) {
            Object value = mapMessage.get(variableName);
            HmDatapoint dp = this.channel.getDatapoint(HmParamsetType.VALUES, variableName);
            if (dp != null) {
                dp.setValue(value);
                continue;
            }
            HmDatapoint dpVariable = new HmDatapoint(variableName, variableName, this.guessType(value), value, false, HmParamsetType.VALUES);
            dpVariable.setInfo(variableName);
            this.channel.addDatapoint(dpVariable);
        }
        return null;
    }

    private HmValueType guessType(Object value) {
        if (value == null) {
            return HmValueType.UNKNOWN;
        }
        if (value instanceof Boolean) {
            return HmValueType.BOOL;
        }
        if (value instanceof Integer || value instanceof Long) {
            return HmValueType.INTEGER;
        }
        if (value instanceof Number) {
            return HmValueType.FLOAT;
        }
        return HmValueType.STRING;
    }
}

