/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetParamsetParser
extends CommonRpcParser<Object[], Void> {
    private final Logger logger = LoggerFactory.getLogger(GetParamsetParser.class);
    private HmChannel channel;
    private HmParamsetType paramsetType;

    public GetParamsetParser(HmChannel channel, HmParamsetType paramsetType) {
        this.channel = channel;
        this.paramsetType = paramsetType;
    }

    @Override
    public Void parse(Object[] message) throws IOException {
        Map mapMessage = (Map)message[0];
        for (String dpName : mapMessage.keySet()) {
            boolean isHmSenMdirNextTrans;
            HmDatapointInfo dpInfo = new HmDatapointInfo(this.paramsetType, this.channel, dpName);
            HmDatapoint dp = this.channel.getDatapoint(dpInfo);
            if (dp != null) {
                dp.setValue(this.convertToType(dp, mapMessage.get(dpName)));
                this.adjustRssiValue(dp);
                continue;
            }
            String deviceType = this.channel.getDevice().getType();
            boolean bl = isHmSenMdirNextTrans = dpInfo.getName().equals("NEXT_TRANSMISSION") && (deviceType.startsWith("HM-Sen-MDIR-O") || deviceType.startsWith("HM-Sen-MDIR-WM55"));
            if (isHmSenMdirNextTrans) continue;
            this.logger.warn("Can't set value for datapoint '{}'", (Object)dpInfo);
        }
        return null;
    }
}

