/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Map;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;

public class ListBidcosInterfacesParser
extends CommonRpcParser<Object[], ListBidcosInterfacesParser> {
    private String type;
    private String gatewayAddress;
    private String firmware;
    private Integer dutyCycleRatio;

    @Override
    public ListBidcosInterfacesParser parse(Object[] message) throws IOException {
        if (message != null && message.length > 0) {
            message = (Object[])message[0];
            int i = 0;
            while (i < message.length) {
                Map mapMessage = (Map)message[i];
                boolean isDefault = this.toBoolean(mapMessage.get("DEFAULT"));
                if (isDefault) {
                    this.type = this.toString(mapMessage.get("TYPE"));
                    this.firmware = this.toString(mapMessage.get("FIRMWARE_VERSION"));
                    this.gatewayAddress = this.getSanitizedAddress(mapMessage.get("ADDRESS"));
                    this.dutyCycleRatio = this.toInteger(mapMessage.get("DUTY_CYCLE"));
                }
                ++i;
            }
        }
        return this;
    }

    public String getType() {
        return this.type;
    }

    public String getGatewayAddress() {
        return this.gatewayAddress;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public Integer getDutyCycleRatio() {
        return this.dutyCycleRatio;
    }
}

