/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;

public class ListDevicesParser
extends CommonRpcParser<Object[], Collection<HmDevice>> {
    private HmInterface hmInterface;
    private HomematicConfig config;

    public ListDevicesParser(HmInterface hmInterface, HomematicConfig config) {
        this.hmInterface = hmInterface;
        this.config = config;
    }

    @Override
    public Collection<HmDevice> parse(Object[] message) throws IOException {
        message = (Object[])message[0];
        HashMap<String, HmDevice> devices = new HashMap<String, HmDevice>();
        int i = 0;
        while (i < message.length) {
            boolean isDevice;
            Map data = (Map)message[i];
            boolean bl = isDevice = !StringUtils.contains((String)this.toString(data.get("ADDRESS")), (String)":");
            if (isDevice) {
                String address = this.getSanitizedAddress(data.get("ADDRESS"));
                String type = MiscUtils.validateCharacters(this.toString(data.get("TYPE")), "Device type", "-");
                String id = this.toString(data.get("ID"));
                String firmware = this.toString(data.get("FIRMWARE"));
                HmDevice device = new HmDevice(address, this.hmInterface, type, this.config.getGatewayInfo().getId(), id, firmware);
                device.addChannel(new HmChannel(type, -1));
                devices.put(address, device);
            } else {
                String deviceAddress = this.getSanitizedAddress(data.get("PARENT"));
                HmDevice device = (HmDevice)devices.get(deviceAddress);
                String type = this.toString(data.get("TYPE"));
                Integer number = this.toInteger(data.get("INDEX"));
                device.addChannel(new HmChannel(type, number));
            }
            ++i;
        }
        return devices.values();
    }
}

