/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.parser;

import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownParameterSetException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.client.UnknownRpcFailureException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.message.RpcRequest;
import org.eclipse.smarthome.binding.homematic.internal.communicator.parser.CommonRpcParser;

public class RpcResponseParser
extends CommonRpcParser<Object[], Object[]> {
    private RpcRequest<?> request;

    public RpcResponseParser(RpcRequest<?> request) {
        this.request = request;
    }

    @Override
    public Object[] parse(Object[] message) throws IOException {
        if (message != null && message.length > 0) {
            Map map;
            Object responseData = message[0];
            if (responseData instanceof Map && (map = (Map)responseData).containsKey("faultCode")) {
                Number faultCode = this.toNumber(map.get("faultCode"));
                String faultString = this.toString(map.get("faultString"));
                String faultMessage = String.format("%s %s (sending %s)", faultCode, faultString, this.request);
                if (faultCode.intValue() == -1 && StringUtils.equals((String)"Failure", (String)faultString)) {
                    throw new UnknownRpcFailureException(faultMessage);
                }
                if (faultCode.intValue() == -3 && StringUtils.equals((String)"Unknown paramset", (String)faultString)) {
                    throw new UnknownParameterSetException(faultMessage);
                }
                throw new IOException(faultMessage);
            }
            return message;
        }
        throw new IOException("Unknown Result: " + message);
    }
}

