/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.server;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.common.HomematicConfig;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.BinRpcNetworkService;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcEventListener;
import org.eclipse.smarthome.binding.homematic.internal.communicator.server.RpcServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinRpcServer
implements RpcServer {
    private final Logger logger = LoggerFactory.getLogger(BinRpcServer.class);
    private Thread networkServiceThread;
    private BinRpcNetworkService networkService;
    private HomematicConfig config;
    private RpcEventListener listener;

    public BinRpcServer(RpcEventListener listener, HomematicConfig config) {
        this.listener = listener;
        this.config = config;
    }

    @Override
    public void start() throws IOException {
        this.logger.debug("Initializing BIN-RPC server at port {}", (Object)this.config.getBinCallbackPort());
        this.networkService = new BinRpcNetworkService(this.listener, this.config);
        this.networkServiceThread = new Thread(this.networkService);
        this.networkServiceThread.setName("HomematicRpcServer");
        this.networkServiceThread.start();
    }

    @Override
    public void shutdown() {
        if (this.networkService != null) {
            this.logger.debug("Stopping BIN-RPC server");
            try {
                if (this.networkServiceThread != null) {
                    this.networkServiceThread.interrupt();
                }
            }
            catch (Exception e) {
                this.logger.error("{}", (Object)e.getMessage(), (Object)e);
            }
            this.networkService.shutdown();
            this.networkService = null;
        }
    }
}

