/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractVirtualDatapointHandler
implements VirtualDatapointHandler {
    private final Logger logger = LoggerFactory.getLogger(AbstractVirtualDatapointHandler.class);

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return false;
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
    }

    @Override
    public boolean canHandleEvent(HmDatapoint dp) {
        return false;
    }

    @Override
    public void handleEvent(VirtualGateway gateway, HmDatapoint dp) {
    }

    @Override
    public HmDatapoint getVirtualDatapoint(HmChannel channel) {
        return channel.getDatapoint(HmParamsetType.VALUES, this.getName());
    }

    protected HmDatapoint addDatapoint(HmDevice device, Integer channelNumber, String datapointName, HmValueType valueType, Object value, boolean readOnly) {
        HmChannel channel = device.getChannel(channelNumber);
        HmDatapoint dp = new HmDatapoint(datapointName, datapointName, valueType, value, readOnly, HmParamsetType.VALUES);
        return this.addDatapoint(channel, dp);
    }

    protected HmDatapoint addDatapoint(HmChannel channel, HmDatapoint dp) {
        this.logger.trace("Adding virtual datapoint '{}' to device '{}' ({}) and channel {}", new Object[]{dp.getName(), channel.getDevice().getAddress(), channel.getDevice().getType(), channel.getNumber()});
        dp.setVirtual(true);
        dp.setReadable(true);
        channel.addDatapoint(dp);
        return dp;
    }
}

