/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class DeleteDeviceModeVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    protected static final String MODE_LOCKED = "LOCKED";
    protected static final String MODE_RESET = "RESET";
    protected static final String MODE_FORCE = "FORCE";
    protected static final String MODE_DEFER = "DEFER";
    private static final int DELETE_MODE_DURATION = 30;

    @Override
    public String getName() {
        return "DELETE_DEVICE_MODE";
    }

    @Override
    public void initialize(HmDevice device) {
        if (!device.isGatewayExtras() && device.getHmInterface() != HmInterface.CUXD) {
            HmDatapoint dp = this.addDatapoint(device, 0, this.getName(), HmValueType.ENUM, 0, false);
            dp.setOptions(new String[]{MODE_LOCKED, MODE_RESET, MODE_FORCE, MODE_DEFER});
            dp.setMinValue(0);
            dp.setMaxValue(dp.getOptions().length - 1);
        }
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        return this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        dp.setValue(value);
        if (!StringUtils.equals((String)dp.getOptionValue(), (String)MODE_LOCKED)) {
            gateway.disableDatapoint(dp, 30.0);
        }
    }
}

