/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class HmwIoModuleVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return null;
    }

    @Override
    public void initialize(HmDevice device) {
        if (device.getType().startsWith("HMW-IO-12-Sw14-DR")) {
            for (HmChannel channel : device.getChannels()) {
                HmDatapointInfo dpInfoCalibration;
                if (channel.getNumber() >= 7) {
                    HmDatapoint dp;
                    HmDatapointInfo dpInfoState = HmDatapointInfo.createValuesInfo(channel, "STATE");
                    HmDatapointInfo dpInfoValue = HmDatapointInfo.createValuesInfo(channel, "VALUE");
                    boolean hasStateDatapoint = channel.hasDatapoint(dpInfoState);
                    boolean hasValueDatapoint = channel.hasDatapoint(dpInfoValue);
                    if (hasStateDatapoint && !hasValueDatapoint) {
                        dp = this.addDatapoint(channel.getDevice(), channel.getNumber(), "VALUE", HmValueType.FLOAT, 0.0, false);
                        dp.setMinValue(0.0);
                        dp.setMaxValue(1000.0);
                        dp.setVirtual(false);
                    } else if (hasValueDatapoint && !hasStateDatapoint) {
                        dp = this.addDatapoint(channel.getDevice(), channel.getNumber(), "STATE", HmValueType.BOOL, false, false);
                        dp.setVirtual(false);
                    }
                }
                if (channel.getNumber() < 21 || channel.hasDatapoint(dpInfoCalibration = new HmDatapointInfo(HmParamsetType.MASTER, channel, "CALIBRATION"))) continue;
                HmDatapoint dp = new HmDatapoint("CALIBRATION", "CALIBRATION", HmValueType.INTEGER, 0, false, HmParamsetType.MASTER);
                dp.setMinValue(-127);
                dp.setMaxValue(127);
                this.addDatapoint(channel, dp);
                dp.setVirtual(false);
            }
        }
    }
}

