/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import java.io.IOException;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointConfig;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OnTimeAutomaticVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    private final Logger logger = LoggerFactory.getLogger(OnTimeAutomaticVirtualDatapointHandler.class);

    @Override
    public String getName() {
        return "ON_TIME_AUTOMATIC";
    }

    @Override
    public void initialize(HmDevice device) {
        for (HmChannel channel : device.getChannels()) {
            HmDatapointInfo dpInfoOnTime;
            if (!channel.hasDatapoint(dpInfoOnTime = HmDatapointInfo.createValuesInfo(channel, "ON_TIME"))) continue;
            HmDatapointInfo dpInfoLevel = HmDatapointInfo.createValuesInfo(channel, "LEVEL");
            HmDatapointInfo dpInfoState = HmDatapointInfo.createValuesInfo(channel, "STATE");
            if (!channel.hasDatapoint(dpInfoLevel) && !channel.hasDatapoint(dpInfoState)) continue;
            HmDatapoint dpOnTime = channel.getDatapoint(dpInfoOnTime);
            HmDatapoint dpOnTimeAutomatic = dpOnTime.clone();
            dpOnTimeAutomatic.setName(this.getName());
            dpOnTimeAutomatic.setDescription(this.getName());
            this.addDatapoint(channel, dpOnTimeAutomatic);
        }
    }

    @Override
    public boolean canHandleCommand(HmDatapoint dp, Object value) {
        boolean isState;
        boolean isLevel = "LEVEL".equals(dp.getName()) && value != null && value instanceof Number && ((Number)value).doubleValue() > 0.0;
        boolean bl = isState = "STATE".equals(dp.getName()) && MiscUtils.isTrueValue(value);
        return (isLevel || isState) && this.getVirtualDatapointValue(dp.getChannel()) > 0.0 || this.getName().equals(dp.getName());
    }

    @Override
    public void handleCommand(VirtualGateway gateway, HmDatapoint dp, HmDatapointConfig dpConfig, Object value) throws IOException, HomematicClientException {
        if (!this.getName().equals(dp.getName())) {
            HmChannel channel = dp.getChannel();
            HmDatapoint dpOnTime = channel.getDatapoint(HmDatapointInfo.createValuesInfo(channel, "ON_TIME"));
            if (dpOnTime != null) {
                gateway.sendDatapoint(dpOnTime, new HmDatapointConfig(), this.getVirtualDatapointValue(channel), null);
            } else {
                this.logger.warn("Can't find ON_TIME datapoint in channel '{}' in device '{}', ignoring virtual datapoint '{}'", new Object[]{channel.getNumber(), channel.getDevice().getAddress(), this.getName()});
            }
            gateway.sendDatapointIgnoreVirtual(dp, dpConfig, value);
        } else {
            dp.setValue(value);
        }
    }

    private Double getVirtualDatapointValue(HmChannel channel) {
        HmDatapoint dpOnTimeAutomatic = this.getVirtualDatapoint(channel);
        return dpOnTimeAutomatic == null || dpOnTimeAutomatic.getValue() == null || dpOnTimeAutomatic.getType() != HmValueType.FLOAT ? 0.0 : ((Number)dpOnTimeAutomatic.getValue()).doubleValue();
    }
}

