/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.communicator.virtual;

import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.AbstractVirtualDatapointHandler;
import org.eclipse.smarthome.binding.homematic.internal.communicator.virtual.VirtualGateway;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class StateContactVirtualDatapointHandler
extends AbstractVirtualDatapointHandler {
    @Override
    public String getName() {
        return "STATE_CONTACT";
    }

    @Override
    public void initialize(HmDevice device) {
        HmDatapointInfo dpStateInfo;
        HmDatapoint dpState;
        HmChannel channelOne;
        if (this.isApplicable(device) && (channelOne = device.getChannel(1)) != null && (dpState = channelOne.getDatapoint(dpStateInfo = HmDatapointInfo.createValuesInfo(channelOne, "STATE"))) != null) {
            this.addDatapoint(device, 1, this.getName(), HmValueType.BOOL, this.convertState(dpState.getValue()), true);
        }
    }

    @Override
    public boolean canHandleEvent(HmDatapoint dp) {
        return this.isApplicable(dp.getChannel().getDevice()) && "STATE".equals(dp.getName());
    }

    @Override
    public void handleEvent(VirtualGateway gateway, HmDatapoint dp) {
        Boolean value = this.convertState(dp.getValue());
        HmDatapoint vdp = this.getVirtualDatapoint(dp.getChannel());
        vdp.setValue(value);
    }

    private boolean isApplicable(HmDevice device) {
        return device.getType().startsWith("HMIP-SWDO");
    }

    private Boolean convertState(Object value) {
        if (!(value instanceof Integer)) {
            return null;
        }
        if ((Integer)value == 0) {
            return true;
        }
        if ((Integer)value == 1) {
            return false;
        }
        return null;
    }
}

