/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter;

import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;

public class StateInvertInfo {
    private String deviceType;
    private int minChannel;
    private int maxChannel;

    public StateInvertInfo(String deviceType) {
        this(deviceType, -1, -1);
    }

    public StateInvertInfo(String deviceType, int minChannel, int maxChannel) {
        this.deviceType = deviceType;
        this.minChannel = minChannel;
        this.maxChannel = maxChannel;
    }

    public boolean isToInvert(HmDatapoint dp) {
        String dpDeviceType = dp.getChannel().getDevice().getType();
        if (this.minChannel != -1) {
            int dpChannelNumber = dp.getChannel().getNumber();
            return dpDeviceType.startsWith(this.deviceType) && dpChannelNumber >= this.minChannel && dpChannelNumber <= this.maxChannel;
        }
        return dpDeviceType.startsWith(this.deviceType);
    }
}

