/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter.type;

import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.AbstractTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.types.Type;

public class OnOffTypeConverter
extends AbstractTypeConverter<OnOffType> {
    @Override
    protected boolean toBindingValidation(HmDatapoint dp, Class<? extends Type> typeClass) {
        return dp.isBooleanType() && typeClass.isAssignableFrom(OnOffType.class);
    }

    @Override
    protected Object toBinding(OnOffType type, HmDatapoint dp) throws ConverterException {
        return (type == OnOffType.OFF ? Boolean.FALSE : Boolean.TRUE) ^ this.isInvert(dp);
    }

    @Override
    protected boolean fromBindingValidation(HmDatapoint dp) {
        return dp.isBooleanType() && dp.getValue() instanceof Boolean;
    }

    @Override
    protected OnOffType fromBinding(HmDatapoint dp) throws ConverterException {
        return (Boolean)dp.getValue() == Boolean.FALSE != this.isInvert(dp) ? OnOffType.OFF : OnOffType.ON;
    }

    private boolean isInvert(HmDatapoint dp) {
        return "SENSOR".equals(dp.getName()) || this.isStateInvertDatapoint(dp);
    }
}

