/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.converter.type;

import org.eclipse.smarthome.binding.homematic.internal.converter.ConverterException;
import org.eclipse.smarthome.binding.homematic.internal.converter.type.AbstractTypeConverter;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.types.Type;

public class OpenClosedTypeConverter
extends AbstractTypeConverter<OpenClosedType> {
    @Override
    protected boolean toBindingValidation(HmDatapoint dp, Class<? extends Type> typeClass) {
        return dp.isBooleanType() && typeClass.isAssignableFrom(OpenClosedType.class);
    }

    @Override
    protected Object toBinding(OpenClosedType type, HmDatapoint dp) throws ConverterException {
        return (type == OpenClosedType.CLOSED ? Boolean.FALSE : Boolean.TRUE) ^ this.isInvert(dp);
    }

    @Override
    protected boolean fromBindingValidation(HmDatapoint dp) {
        return dp.isBooleanType() && dp.getValue() instanceof Boolean;
    }

    @Override
    protected OpenClosedType fromBinding(HmDatapoint dp) throws ConverterException {
        return (Boolean)dp.getValue() == Boolean.FALSE != this.isInvert(dp) ? OpenClosedType.CLOSED : OpenClosedType.OPEN;
    }

    private boolean isInvert(HmDatapoint dp) {
        return !"SENSOR".equals(dp.getName()) && !this.isStateInvertDatapoint(dp);
    }
}

