/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.discovery;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketTimeoutException;
import java.util.Collections;
import java.util.concurrent.Future;
import org.eclipse.smarthome.binding.homematic.HomematicBindingConstants;
import org.eclipse.smarthome.binding.homematic.internal.discovery.eq3udp.Eq3UdpRequest;
import org.eclipse.smarthome.binding.homematic.internal.discovery.eq3udp.Eq3UdpResponse;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.net.NetworkAddressService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DiscoveryService.class}, immediate=true, configurationPid="discovery.homematic")
public class CcuDiscoveryService
extends AbstractDiscoveryService {
    private final Logger logger = LoggerFactory.getLogger(CcuDiscoveryService.class);
    private static final int RECEIVE_TIMEOUT_MSECS = 3000;
    private InetAddress broadcastAddress;
    private MulticastSocket socket;
    private Future<?> scanFuture;
    private NetworkAddressService networkAddressService;

    public CcuDiscoveryService() {
        super(Collections.singleton(HomematicBindingConstants.THING_TYPE_BRIDGE), 5, true);
    }

    protected void startScan() {
        if (this.scanFuture == null) {
            this.scanFuture = this.scheduler.submit(this::startDiscovery);
        } else {
            this.logger.debug("Homematic CCU background discovery scan in progress");
        }
    }

    protected void stopScan() {
        if (this.scanFuture != null) {
            this.scanFuture.cancel(false);
            this.scanFuture = null;
        }
    }

    protected void startBackgroundDiscovery() {
        this.startScan();
    }

    protected void stopBackgroundDiscovery() {
        this.stopScan();
    }

    private synchronized void startDiscovery() {
        try {
            this.logger.debug("Starting Homematic CCU discovery scan");
            String configuredBroadcastAddress = this.networkAddressService.getConfiguredBroadcastAddress();
            if (configuredBroadcastAddress != null) {
                this.broadcastAddress = InetAddress.getByName(configuredBroadcastAddress);
            }
            if (this.broadcastAddress == null) {
                this.logger.warn("Homematic CCU discovery: discovery not possible, no broadcast address found");
                return;
            }
            try {
                this.socket = new MulticastSocket();
                this.socket.setBroadcast(true);
                this.socket.setTimeToLive(5);
                this.socket.setSoTimeout(800);
                this.sendBroadcast();
                this.receiveResponses();
            }
            catch (Exception ex) {
                this.logger.error("An error was thrown while running Homematic CCU discovery {}", (Object)ex.getMessage(), (Object)ex);
            }
        }
        finally {
            this.scanFuture = null;
        }
    }

    private void sendBroadcast() throws IOException {
        Eq3UdpRequest hello = new Eq3UdpRequest();
        byte[] data = hello.getBytes();
        DatagramPacket packet = new DatagramPacket(data, data.length, this.broadcastAddress, 43439);
        this.socket.send(packet);
    }

    private void receiveResponses() throws IOException {
        long startTime = System.currentTimeMillis();
        long currentTime = System.currentTimeMillis();
        while (currentTime - startTime < 3000L) {
            this.extractGatewayInfos();
            currentTime = System.currentTimeMillis();
        }
        this.socket.close();
    }

    private void extractGatewayInfos() throws IOException {
        try {
            DatagramPacket packet = new DatagramPacket(new byte[265], 256);
            this.socket.receive(packet);
            Eq3UdpResponse response = new Eq3UdpResponse(packet.getData());
            this.logger.trace("Eq3UdpResponse: {}", (Object)response);
            if (response.isValid()) {
                this.logger.debug("Discovered a CCU gateway with serial number '{}'", (Object)response.getSerialNumber());
                String address = packet.getAddress().getHostAddress();
                ThingUID thingUid = new ThingUID(HomematicBindingConstants.THING_TYPE_BRIDGE, response.getSerialNumber());
                this.thingDiscovered(DiscoveryResultBuilder.create((ThingUID)thingUid).withProperty("gatewayAddress", (Object)address).withRepresentationProperty("gatewayAddress").withLabel(String.valueOf(response.getDeviceTypeId()) + " - " + address).build());
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {}
    }

    @Reference
    protected void setNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = networkAddressService;
    }

    protected void unsetNetworkAddressService(NetworkAddressService networkAddressService) {
        this.networkAddressService = null;
    }
}

