/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.discovery;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.eclipse.smarthome.binding.homematic.HomematicBindingConstants;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.UpnpDiscoveryParticipant;
import org.eclipse.smarthome.core.thing.ThingTypeUID;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.jupnp.model.meta.DeviceDetails;
import org.jupnp.model.meta.RemoteDevice;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true)
public class HomegearDiscoveryParticipant
implements UpnpDiscoveryParticipant {
    private final Logger logger = LoggerFactory.getLogger(HomegearDiscoveryParticipant.class);

    public Set<ThingTypeUID> getSupportedThingTypeUIDs() {
        return Collections.singleton(HomematicBindingConstants.THING_TYPE_BRIDGE);
    }

    public DiscoveryResult createResult(RemoteDevice device) {
        ThingUID uid = this.getThingUID(device);
        if (uid != null) {
            DeviceDetails details = device.getDetails();
            HashMap<String, String> properties = new HashMap<String, String>(3);
            properties.put("gatewayAddress", details.getBaseURL().getHost());
            this.logger.debug("Discovered a Homegear gateway with serial number '{}'", (Object)details.getSerialNumber());
            return DiscoveryResultBuilder.create((ThingUID)uid).withProperties(properties).withLabel(details.getModelDetails().getModelNumber()).build();
        }
        return null;
    }

    public ThingUID getThingUID(RemoteDevice device) {
        DeviceDetails details = device.getDetails();
        String modelName = details.getModelDetails().getModelName();
        if ("HOMEGEAR".equalsIgnoreCase(modelName)) {
            return new ThingUID(HomematicBindingConstants.THING_TYPE_BRIDGE, details.getSerialNumber());
        }
        return null;
    }
}

