/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.discovery.eq3udp;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.homematic.internal.discovery.eq3udp.Eq3UdpRequest;

public class Eq3UdpResponse {
    private int senderId;
    private String deviceTypeId;
    private String serialNumber;

    public Eq3UdpResponse(byte[] buffer) throws IndexOutOfBoundsException {
        int index = 0;
        byte protocolVersion = buffer[index++];
        if (protocolVersion == 2) {
            this.senderId = this.readInt(buffer, index, 3);
            index += 4;
        }
        this.deviceTypeId = this.readString(buffer, index++);
        this.serialNumber = this.readString(buffer, index += this.deviceTypeId.length());
    }

    public String getDeviceTypeId() {
        return this.deviceTypeId;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public boolean isValid() {
        return this.senderId == Eq3UdpRequest.getSenderId() && (this.deviceTypeId.startsWith("eQ3-HM-CCU") || this.deviceTypeId.startsWith("eQ3-HmIP-CCU3")) && !this.serialNumber.contains(Eq3UdpRequest.getEq3SerialNumber());
    }

    private String readString(byte[] data, int index) throws IndexOutOfBoundsException {
        String result = "";
        int i = index;
        while (i < data.length) {
            if (data[i] == 0) break;
            result = String.valueOf(result) + (char)data[i];
            ++i;
        }
        return result;
    }

    private int readInt(byte[] data, int index, int length) throws IndexOutOfBoundsException {
        int result = 0;
        int n = index;
        while (n < index + length) {
            result <<= 8;
            result |= data[n] & 0xFF;
            ++n;
        }
        return result;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("deviceTypeId", (Object)this.deviceTypeId).append("serialNumber", (Object)this.serialNumber).toString();
    }
}

