/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.misc;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.smarthome.binding.homematic.internal.misc.HomematicClientException;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedExecuter {
    private final Logger logger = LoggerFactory.getLogger(DelayedExecuter.class);
    private Map<HmDatapointInfo, Timer> delayedEvents = new HashMap<HmDatapointInfo, Timer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(final HmDatapointInfo dpInfo, double delay, final DelayedExecuterCallback callback) throws IOException, HomematicClientException {
        if (delay > 0.0) {
            Class<DelayedExecuter> clazz = DelayedExecuter.class;
            synchronized (DelayedExecuter.class) {
                this.logger.debug("Delaying event for {} seconds: '{}'", (Object)delay, (Object)dpInfo);
                Timer timer = this.delayedEvents.get(dpInfo);
                if (timer != null) {
                    timer.cancel();
                }
                timer = new Timer();
                this.delayedEvents.put(dpInfo, timer);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        DelayedExecuter.this.logger.debug("Executing delayed event for '{}'", (Object)dpInfo);
                        DelayedExecuter.this.delayedEvents.remove(dpInfo);
                        try {
                            callback.execute();
                        }
                        catch (Exception ex) {
                            DelayedExecuter.this.logger.error("{}", (Object)ex.getMessage(), (Object)ex);
                        }
                    }
                }, (long)(delay * 1000.0));
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        } else {
            callback.execute();
        }
    }

    public void stop() {
        for (Timer timer : this.delayedEvents.values()) {
            timer.cancel();
        }
        this.delayedEvents.clear();
    }

    public static interface DelayedExecuterCallback {
        public void execute() throws IOException, HomematicClientException;
    }
}

