/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;

public class HmChannel {
    public static final String TYPE_GATEWAY_EXTRAS = "GATEWAY-EXTRAS";
    public static final String TYPE_GATEWAY_VARIABLE = "GATEWAY-VARIABLE";
    public static final String TYPE_GATEWAY_SCRIPT = "GATEWAY-SCRIPT";
    public static final Integer CHANNEL_NUMBER_EXTRAS = 0;
    public static final Integer CHANNEL_NUMBER_VARIABLE = 1;
    public static final Integer CHANNEL_NUMBER_SCRIPT = 2;
    private final Integer number;
    private final String type;
    private HmDevice device;
    private boolean initialized;
    private Integer lastFunction;
    private Map<HmDatapointInfo, HmDatapoint> datapoints = new HashMap<HmDatapointInfo, HmDatapoint>();

    public HmChannel(String type, Integer number) {
        this.type = type;
        this.number = number;
    }

    public Integer getNumber() {
        return this.number;
    }

    public HmDevice getDevice() {
        return this.device;
    }

    public void setDevice(HmDevice device) {
        this.device = device;
    }

    public String getType() {
        return this.type;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public boolean isGatewayScript() {
        return this.device.isGatewayExtras() && TYPE_GATEWAY_SCRIPT.equals(this.type);
    }

    public boolean isGatewayVariable() {
        return this.device.isGatewayExtras() && TYPE_GATEWAY_VARIABLE.equals(this.type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<HmDatapoint> getDatapoints() {
        Map<HmDatapointInfo, HmDatapoint> map = this.datapoints;
        synchronized (map) {
            return new ArrayList<HmDatapoint>(this.datapoints.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDatapoint(HmDatapoint dp) {
        dp.setChannel(this);
        Map<HmDatapointInfo, HmDatapoint> map = this.datapoints;
        synchronized (map) {
            this.datapoints.put(new HmDatapointInfo(dp), dp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeValueDatapoints() {
        Map<HmDatapointInfo, HmDatapoint> map = this.datapoints;
        synchronized (map) {
            Iterator<Map.Entry<HmDatapointInfo, HmDatapoint>> iterator = this.datapoints.entrySet().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getKey().getParamsetType() != HmParamsetType.VALUES) continue;
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HmDatapoint getDatapoint(HmDatapointInfo dpInfo) {
        Map<HmDatapointInfo, HmDatapoint> map = this.datapoints;
        synchronized (map) {
            return this.datapoints.get(dpInfo);
        }
    }

    public HmDatapoint getDatapoint(HmParamsetType type, String datapointName) {
        return this.getDatapoint(new HmDatapointInfo(type, this, datapointName));
    }

    public boolean hasDatapoint(HmDatapointInfo dpInfo) {
        return this.getDatapoint(dpInfo) != null;
    }

    public boolean isReconfigurable() {
        return this.getDatapoint(HmParamsetType.MASTER, "CHANNEL_FUNCTION") != null;
    }

    public Integer getCurrentFunction() {
        HmDatapoint functionDp = this.getDatapoint(HmParamsetType.MASTER, "CHANNEL_FUNCTION");
        return functionDp == null ? null : (Integer)functionDp.getValue();
    }

    public synchronized boolean checkForChannelFunctionChange() {
        Integer currentFunction = this.getCurrentFunction();
        if (currentFunction == null) {
            return false;
        }
        if (this.lastFunction == null) {
            this.lastFunction = currentFunction;
            return false;
        }
        if (this.lastFunction.equals(currentFunction)) {
            return false;
        }
        this.lastFunction = currentFunction;
        return true;
    }

    public boolean hasPressDatapoint() {
        for (HmDatapoint dp : this.getDatapoints()) {
            if (!dp.isPressDatapoint()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("number", (Object)this.number).append("type", (Object)this.type).append("initialized", this.initialized).toString();
    }
}

