/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.model;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;
import org.eclipse.smarthome.binding.homematic.internal.model.HmValueType;

public class HmDatapoint
implements Cloneable {
    private HmChannel channel;
    private String name;
    private String description;
    private Object value;
    private Object previousValue;
    private Object defaultValue;
    private HmValueType type;
    private HmParamsetType paramsetType;
    private Number minValue;
    private Number maxValue;
    private Number step;
    private String[] options;
    private boolean readOnly;
    private boolean readable;
    private String info;
    private String unit;
    private boolean virtual;
    private boolean trigger;

    public HmDatapoint() {
    }

    public HmDatapoint(String name, String description, HmValueType type, Object value, boolean readOnly, HmParamsetType paramsetType) {
        this.description = description;
        this.type = type;
        this.readOnly = readOnly;
        this.paramsetType = paramsetType;
        this.value = value;
        this.setName(name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = MiscUtils.validateCharacters(name, "Datapoint name", "_");
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public HmChannel getChannel() {
        return this.channel;
    }

    public void setChannel(HmChannel channel) {
        this.channel = channel;
    }

    public Object getValue() {
        return this.value;
    }

    public Object getPreviousValue() {
        return this.previousValue;
    }

    public void setValue(Object value) {
        this.previousValue = this.value;
        this.value = value;
    }

    public String[] getOptions() {
        return this.options;
    }

    public void setOptions(String[] options) {
        this.options = options;
    }

    public int getOptionIndex(String option) {
        if (this.options != null && option != null) {
            int i = 0;
            while (i < this.options.length) {
                String value = this.options[i];
                if (option.equalsIgnoreCase(value)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public String getOptionValue() {
        if (this.options != null && this.value != null) {
            int idx = 0;
            idx = this.value instanceof Integer ? (Integer)this.value : Integer.parseInt(this.value.toString());
            if (idx < this.options.length) {
                return this.options[idx];
            }
        }
        return null;
    }

    public Number getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(Number maxValue) {
        this.maxValue = maxValue;
    }

    public Number getMinValue() {
        return this.minValue;
    }

    public void setMinValue(Number minValue) {
        this.minValue = minValue;
    }

    public Number getStep() {
        return this.step;
    }

    public void setStep(Number step) {
        this.step = step;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public HmValueType getType() {
        return this.type;
    }

    public void setType(HmValueType type) {
        this.type = type;
    }

    public HmParamsetType getParamsetType() {
        return this.paramsetType;
    }

    public void setParamsetType(HmParamsetType paramsetType) {
        this.paramsetType = paramsetType;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public boolean isActionType() {
        return this.type == HmValueType.ACTION;
    }

    public boolean isBooleanType() {
        return this.type == HmValueType.BOOL || this.type == HmValueType.ACTION;
    }

    public boolean isFloatType() {
        return this.type == HmValueType.FLOAT;
    }

    public boolean isIntegerType() {
        return this.type == HmValueType.INTEGER;
    }

    public boolean isNumberType() {
        return this.isIntegerType() || this.isFloatType();
    }

    public boolean isStringType() {
        return this.type == HmValueType.STRING;
    }

    public boolean isEnumType() {
        return this.type == HmValueType.ENUM;
    }

    public boolean isDateTimeType() {
        return this.type == HmValueType.DATETIME;
    }

    public boolean isVariable() {
        return this.channel.isGatewayVariable();
    }

    public boolean isScript() {
        return this.channel.isGatewayScript();
    }

    public boolean isPressDatapoint() {
        return this.name != null && this.name.startsWith("PRESS_");
    }

    public void setTrigger(boolean trigger) {
        this.trigger = trigger;
    }

    public boolean isTrigger() {
        return this.trigger;
    }

    public HmDatapoint clone() {
        HmDatapoint dp = new HmDatapoint(this.name, this.description, this.type, this.value, this.readOnly, this.paramsetType);
        dp.setChannel(this.channel);
        dp.setMinValue(this.minValue);
        dp.setMaxValue(this.maxValue);
        dp.setStep(this.step);
        dp.setOptions(this.options);
        dp.setInfo(this.info);
        dp.setUnit(this.unit);
        dp.setVirtual(this.virtual);
        dp.setReadable(this.readable);
        dp.setTrigger(this.trigger);
        dp.setDefaultValue(this.defaultValue);
        return dp;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).append("value", this.value).append("defaultValue", this.defaultValue).append("type", (Object)this.type).append("minValue", (Object)this.minValue).append("maxValue", (Object)this.maxValue).append("step", (Object)this.step).append("options", (Object)StringUtils.join((Object[])this.options, (String)";")).append("readOnly", this.readOnly).append("readable", this.readable).append("unit", (Object)this.unit).append("description", (Object)this.description).append("info", (Object)this.info).append("paramsetType", (Object)this.paramsetType).append("virtual", this.virtual).append("trigger", this.trigger).toString();
    }
}

