/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.model;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmParamsetType;

public class HmDatapointInfo {
    private String address;
    private Integer channel;
    private String name;
    private HmParamsetType paramsetType;

    public HmDatapointInfo(HmDatapoint dp) {
        this(dp.getParamsetType(), dp.getChannel(), dp.getName());
    }

    public HmDatapointInfo(HmParamsetType paramsetType, HmChannel channel, String name) {
        this(channel.getDevice().getAddress(), paramsetType, channel.getNumber(), name);
    }

    public HmDatapointInfo(String address, HmParamsetType paramsetType, Integer channel, String name) {
        this.address = address;
        this.channel = channel;
        this.paramsetType = paramsetType;
        this.name = name;
    }

    public static HmDatapointInfo createValuesInfo(HmChannel channel, String name) {
        return new HmDatapointInfo(HmParamsetType.VALUES, channel, name);
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getChannel() {
        return this.channel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public HmParamsetType getParamsetType() {
        return this.paramsetType;
    }

    public boolean isPong() {
        return "CENTRAL".equals(this.address) && "PONG".equals(this.name);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.address).append((Object)this.paramsetType).append((Object)this.channel).append((Object)this.name).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HmDatapointInfo)) {
            return false;
        }
        HmDatapointInfo comp = (HmDatapointInfo)obj;
        return new EqualsBuilder().append((Object)this.address, (Object)comp.getAddress()).append((Object)this.paramsetType, (Object)comp.getParamsetType()).append((Object)this.channel, (Object)comp.getChannel()).append((Object)this.name, (Object)comp.getName()).isEquals();
    }

    public String toString() {
        if (this.paramsetType == HmParamsetType.VALUES) {
            return String.format("%s:%s#%s", this.address, this.channel, this.name);
        }
        return String.format("%s:%s_%s#%s", this.address, this.paramsetType.getId(), this.channel, this.name);
    }
}

