/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.eclipse.smarthome.binding.homematic.internal.misc.MiscUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmChannel;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapointInfo;
import org.eclipse.smarthome.binding.homematic.internal.model.HmInterface;

public class HmDevice {
    public static final String TYPE_GATEWAY_EXTRAS = "GATEWAY-EXTRAS";
    public static final String ADDRESS_GATEWAY_EXTRAS = "GWE00000000";
    private final HmInterface hmInterface;
    private final String address;
    private final String type;
    private String name;
    private final String firmware;
    private final String gatewayId;
    private final String homegearId;
    private List<HmChannel> channels = new ArrayList<HmChannel>();

    public HmDevice(String address, HmInterface hmInterface, String type, String gatewayId, String homegearId, String firmware) {
        this.address = address;
        this.hmInterface = hmInterface;
        this.type = type;
        this.gatewayId = gatewayId;
        this.homegearId = homegearId;
        this.firmware = firmware;
    }

    public String getAddress() {
        return this.address;
    }

    public HmInterface getHmInterface() {
        return this.hmInterface;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public List<HmChannel> getChannels() {
        return this.channels;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public String getGatewayId() {
        return this.gatewayId;
    }

    public String getHomegearId() {
        return this.homegearId;
    }

    public void addChannel(HmChannel channel) {
        channel.setDevice(this);
        this.channels.add(channel);
    }

    public HmChannel getChannel(int channelNumber) {
        for (HmChannel hmChannel : this.channels) {
            if (hmChannel.getNumber() != channelNumber) continue;
            return hmChannel;
        }
        return null;
    }

    public int getDatapointCount() {
        int dpCounter = 0;
        for (HmChannel channel : this.channels) {
            dpCounter += channel.getDatapoints().size();
        }
        return dpCounter;
    }

    public boolean isGatewayExtras() {
        return ADDRESS_GATEWAY_EXTRAS.equals(this.address);
    }

    public boolean isUnreach() {
        return this.isStatusDatapointEnabled("UNREACH");
    }

    public boolean isConfigPending() {
        return this.isStatusDatapointEnabled("CONFIG_PENDING");
    }

    public boolean isUpdatePending() {
        return this.isStatusDatapointEnabled("UPDATE_PENDING");
    }

    public boolean isFirmwareUpdating() {
        return this.isStatusDatapointEnabled("DEVICE_IN_BOOTLOADER");
    }

    public boolean isOffline() {
        return this.isFirmwareUpdating() || this.isUnreach();
    }

    private boolean isStatusDatapointEnabled(String datapointName) {
        HmDatapointInfo dpInfo;
        HmDatapoint dp;
        HmChannel channel = this.getChannel(0);
        if (channel != null && channel.isInitialized() && (dp = channel.getDatapoint(dpInfo = HmDatapointInfo.createValuesInfo(channel, datapointName))) != null) {
            return MiscUtils.isTrueValue(dp.getValue());
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.address).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HmDevice)) {
            return false;
        }
        HmDevice comp = (HmDevice)obj;
        return new EqualsBuilder().append((Object)this.address, (Object)comp.getAddress()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("hmInterface", (Object)this.hmInterface).append("address", (Object)this.address).append("type", (Object)this.type).append("name", (Object)this.name).append("firmware", (Object)this.firmware).append("gatewayId", (Object)this.gatewayId).toString();
    }
}

