/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicChannelGroupTypeProvider;
import org.eclipse.smarthome.binding.homematic.type.HomematicThingTypeExcluder;
import org.eclipse.smarthome.core.thing.type.ChannelGroupType;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelGroupTypeUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={HomematicChannelGroupTypeProvider.class, ChannelGroupTypeProvider.class}, immediate=true)
public class HomematicChannelGroupTypeProviderImpl
implements HomematicChannelGroupTypeProvider {
    private final Map<ChannelGroupTypeUID, ChannelGroupType> channelGroupTypesByUID = new HashMap<ChannelGroupTypeUID, ChannelGroupType>();
    protected List<HomematicThingTypeExcluder> homematicThingTypeExcluders = new CopyOnWriteArrayList<HomematicThingTypeExcluder>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.add(homematicThingTypeExcluder);
        }
    }

    protected void removeHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.remove(homematicThingTypeExcluder);
        }
    }

    private boolean isChannelGroupTypeExcluded(ChannelGroupTypeUID channelGroupTypeUID) {
        for (HomematicThingTypeExcluder excluder : this.homematicThingTypeExcluders) {
            if (!excluder.isChannelGroupTypeExcluded(channelGroupTypeUID)) continue;
            return true;
        }
        return false;
    }

    public ChannelGroupType getChannelGroupType(ChannelGroupTypeUID channelGroupTypeUID, Locale locale) {
        return this.isChannelGroupTypeExcluded(channelGroupTypeUID) ? null : this.channelGroupTypesByUID.get(channelGroupTypeUID);
    }

    @Override
    public ChannelGroupType getInternalChannelGroupType(ChannelGroupTypeUID channelGroupTypeUID) {
        return this.channelGroupTypesByUID.get(channelGroupTypeUID);
    }

    public Collection<ChannelGroupType> getChannelGroupTypes(Locale locale) {
        ArrayList<ChannelGroupType> result = new ArrayList<ChannelGroupType>();
        for (ChannelGroupTypeUID uid : this.channelGroupTypesByUID.keySet()) {
            if (this.isChannelGroupTypeExcluded(uid)) continue;
            result.add(this.channelGroupTypesByUID.get(uid));
        }
        return result;
    }

    @Override
    public void addChannelGroupType(ChannelGroupType channelGroupType) {
        this.channelGroupTypesByUID.put(channelGroupType.getUID(), channelGroupType);
    }
}

