/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.smarthome.binding.homematic.internal.type.HomematicChannelTypeProvider;
import org.eclipse.smarthome.binding.homematic.type.HomematicThingTypeExcluder;
import org.eclipse.smarthome.core.thing.type.ChannelType;
import org.eclipse.smarthome.core.thing.type.ChannelTypeProvider;
import org.eclipse.smarthome.core.thing.type.ChannelTypeUID;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={HomematicChannelTypeProvider.class, ChannelTypeProvider.class}, immediate=true)
public class HomematicChannelTypeProviderImpl
implements HomematicChannelTypeProvider {
    private final Map<ChannelTypeUID, ChannelType> channelTypesByUID = new HashMap<ChannelTypeUID, ChannelType>();
    protected List<HomematicThingTypeExcluder> homematicThingTypeExcluders = new CopyOnWriteArrayList<HomematicThingTypeExcluder>();

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.add(homematicThingTypeExcluder);
        }
    }

    protected void removeHomematicThingTypeExcluder(HomematicThingTypeExcluder homematicThingTypeExcluder) {
        if (this.homematicThingTypeExcluders != null) {
            this.homematicThingTypeExcluders.remove(homematicThingTypeExcluder);
        }
    }

    private boolean isChannelTypeExcluded(ChannelTypeUID channelTypeUID) {
        for (HomematicThingTypeExcluder excluder : this.homematicThingTypeExcluders) {
            if (!excluder.isChannelTypeExcluded(channelTypeUID)) continue;
            return true;
        }
        return false;
    }

    public Collection<ChannelType> getChannelTypes(Locale locale) {
        ArrayList<ChannelType> result = new ArrayList<ChannelType>();
        for (ChannelTypeUID uid : this.channelTypesByUID.keySet()) {
            if (this.isChannelTypeExcluded(uid)) continue;
            result.add(this.channelTypesByUID.get(uid));
        }
        return result;
    }

    public ChannelType getChannelType(ChannelTypeUID channelTypeUID, Locale locale) {
        return this.isChannelTypeExcluded(channelTypeUID) ? null : this.channelTypesByUID.get(channelTypeUID);
    }

    @Override
    public ChannelType getInternalChannelType(ChannelTypeUID channelTypeUID) {
        return this.channelTypesByUID.get(channelTypeUID);
    }

    @Override
    public void addChannelType(ChannelType channelType) {
        this.channelTypesByUID.put(channelType.getUID(), channelType);
    }
}

