/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDatapoint;
import org.eclipse.smarthome.binding.homematic.internal.model.HmDevice;
import org.eclipse.smarthome.config.core.ConfigDescriptionParameter;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataUtils {
    private static final Logger logger = LoggerFactory.getLogger(MetadataUtils.class);
    private static ResourceBundle descriptionsBundle;
    private static Map<String, String> descriptions;
    private static Map<String, Set<String>> standardDatapoints;

    static {
        descriptions = new HashMap<String, String>();
        standardDatapoints = new HashMap<String, Set<String>>();
    }

    protected static void initialize() {
        MetadataUtils.loadBundle("homematic/generated-descriptions");
        MetadataUtils.loadBundle("homematic/extra-descriptions");
        MetadataUtils.loadStandardDatapoints();
    }

    private static void loadBundle(String filename) {
        descriptionsBundle = ResourceBundle.getBundle(filename, Locale.getDefault());
        for (String key : descriptionsBundle.keySet()) {
            descriptions.put(key, descriptionsBundle.getString(key));
        }
        ResourceBundle.clearCache();
        descriptionsBundle = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadStandardDatapoints() {
        Bundle bundle = FrameworkUtil.getBundle(MetadataUtils.class);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                InputStream stream = bundle.getResource("homematic/standard-datapoints.properties").openStream();
                try {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            if (StringUtils.trimToNull((String)line) == null || StringUtils.startsWith((String)line, (String)"#")) continue;
                            String channelType = StringUtils.trimToNull((String)StringUtils.substringBefore((String)line, (String)"|"));
                            String datapointName = StringUtils.trimToNull((String)StringUtils.substringAfter((String)line, (String)"|"));
                            Set<String> channelDatapoints = standardDatapoints.get(channelType);
                            if (channelDatapoints == null) {
                                channelDatapoints = new HashSet<String>();
                                standardDatapoints.put(channelType, channelDatapoints);
                            }
                            channelDatapoints.add(datapointName);
                        }
                    }
                    if (stream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (stream == null) throw throwable;
                    stream.close();
                    throw throwable;
                }
                stream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | IllegalStateException e) {
            logger.warn("Can't load standard-datapoints.properties file!", (Throwable)e);
        }
    }

    public static <T> List<T> generateOptions(HmDatapoint dp, OptionsBuilder<T> optionsBuilder) {
        ArrayList<T> options = null;
        if (dp.getOptions() == null) {
            logger.warn("No options for ENUM datapoint {}", (Object)dp);
        } else {
            options = new ArrayList<T>();
            int i = 0;
            while (i < dp.getOptions().length) {
                String description = null;
                if (!dp.isVariable() && !dp.isScript()) {
                    description = MetadataUtils.getDescription(dp.getChannel().getType(), dp.getName(), dp.getOptions()[i]);
                }
                if (description == null) {
                    description = dp.getOptions()[i];
                }
                options.add(optionsBuilder.createOption(dp.getOptions()[i], description));
                ++i;
            }
        }
        return options;
    }

    public static ConfigDescriptionParameter.Type getConfigDescriptionParameterType(HmDatapoint dp) {
        if (dp.isBooleanType()) {
            return ConfigDescriptionParameter.Type.BOOLEAN;
        }
        if (dp.isIntegerType()) {
            return ConfigDescriptionParameter.Type.INTEGER;
        }
        if (dp.isFloatType()) {
            return ConfigDescriptionParameter.Type.DECIMAL;
        }
        return ConfigDescriptionParameter.Type.TEXT;
    }

    public static String getUnit(HmDatapoint dp) {
        if (dp.getUnit() != null) {
            String unit = StringUtils.replace((String)dp.getUnit(), (String)"100%", (String)"%");
            return StringUtils.replace((String)unit, (String)"%", (String)"%%");
        }
        return null;
    }

    public static String getPattern(HmDatapoint dp) {
        if (dp.isFloatType()) {
            return "%.2f";
        }
        if (dp.isNumberType()) {
            return "%d";
        }
        return null;
    }

    public static String getStatePattern(HmDatapoint dp) {
        String pattern;
        String unit = MetadataUtils.getUnit(dp);
        if (unit != null && unit != "" && (pattern = MetadataUtils.getPattern(dp)) != null) {
            return String.format("%s %s", pattern, "%unit%");
        }
        return null;
    }

    public static String getLabel(HmDatapoint dp) {
        return WordUtils.capitalizeFully((String)StringUtils.replace((String)dp.getName(), (String)"_", (String)" "));
    }

    public static String getParameterName(HmDatapoint dp) {
        return String.format("HMP_%d_%s", dp.getChannel().getNumber(), dp.getName());
    }

    public static String getDescription(String ... keys) {
        StringBuilder sb = new StringBuilder();
        int startIdx = 0;
        while (startIdx < keys.length) {
            String description;
            String key = StringUtils.join((Object[])keys, (String)"|", (int)startIdx, (int)keys.length);
            if (key.endsWith("|")) {
                key = key.substring(0, key.length() - 1);
            }
            if ((description = descriptions.get(key)) != null) {
                return description;
            }
            sb.append(key).append(", ");
            ++startIdx;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Description not found for: {}", (Object)StringUtils.substring((String)sb.toString(), (int)0, (int)-2));
        }
        return null;
    }

    public static String getDeviceName(HmDevice device) {
        if (device.isGatewayExtras()) {
            return MetadataUtils.getDescription("GATEWAY-EXTRAS");
        }
        String deviceDescription = null;
        boolean isTeam = device.getType().endsWith("-Team");
        String type = isTeam ? StringUtils.remove((String)device.getType(), (String)"-Team") : device.getType();
        deviceDescription = MetadataUtils.getDescription(type);
        if (deviceDescription != null && isTeam) {
            deviceDescription = String.valueOf(deviceDescription) + " Team";
        }
        return deviceDescription == null ? "No Description" : deviceDescription;
    }

    public static String getDatapointDescription(HmDatapoint dp) {
        if (dp.isVariable() || dp.isScript()) {
            return null;
        }
        return MetadataUtils.getDescription(dp.getChannel().getType(), dp.getName());
    }

    public static boolean isStandard(HmDatapoint dp) {
        Set<String> channelDatapoints = standardDatapoints.get(dp.getChannel().getType());
        if (channelDatapoints == null) {
            return true;
        }
        return channelDatapoints.contains(dp.getName());
    }

    public static BigDecimal createBigDecimal(Number number) {
        if (number == null) {
            return null;
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (Exception exception) {
            logger.warn("Can't create BigDecimal for number: {}", (Object)number.toString());
            return null;
        }
    }

    /*
     * Exception decompiling
     */
    public static String getItemType(HmDatapoint dp) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[24] lbl165 : CaseStatement: default:\u000a, @NONE, blocks:[24] lbl165 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isRollerShutter(HmDatapoint dp) {
        String channelType = dp.getChannel().getType();
        return channelType.equals("BLIND") || channelType.equals("JALOUSIE") || channelType.equals("SHUTTER_TRANSMITTER") || channelType.equals("SHUTTER_VIRTUAL_RECEIVER");
    }

    public static String getCategory(HmDatapoint dp, String itemType) {
        String dpName = dp.getName();
        String channelType = StringUtils.defaultString((String)dp.getChannel().getType());
        if (dpName.equals("BATTERY_TYPE") || dpName.equals("LOWBAT") || dpName.equals("LOW_BAT")) {
            return "Battery";
        }
        if (dpName.equals("STATE") && channelType.equals("ALARMACTUATOR")) {
            return "Alarm";
        }
        if (dpName.equals("HUMIDITY")) {
            return "Humidity";
        }
        if (dpName.contains("TEMPERATURE")) {
            return "Temperature";
        }
        if (dpName.equals("MOTION")) {
            return "Motion";
        }
        if (dpName.equals("AIR_PRESSURE")) {
            return "Pressure";
        }
        if (dpName.equals("STATE") && channelType.equals("SMOKE_DETECTOR")) {
            return "Smoke";
        }
        if (dpName.equals("STATE") && channelType.equals("WATERDETECTIONSENSOR")) {
            return "Water";
        }
        if (dpName.equals("WIND_SPEED")) {
            return "Wind";
        }
        if (dpName.startsWith("RAIN") || dpName.equals("STATE") && channelType.equals("RAINDETECTOR")) {
            return "Rain";
        }
        if (channelType.equals("POWERMETER") && !dpName.equals("BOOT") && !dpName.equals("FREQUENCY")) {
            return "Energy";
        }
        if (itemType.equals("Rollershutter")) {
            return "Blinds";
        }
        if (itemType.equals("Contact")) {
            return "Contact";
        }
        if (itemType.equals("Dimmer")) {
            return "DimmableLight";
        }
        if (itemType.equals("Switch")) {
            return "Switch";
        }
        return null;
    }

    public static interface OptionsBuilder<T> {
        public T createOption(String var1, String var2);
    }
}

