/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.homematic.internal.type.generator;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CcuMetadataExtractor {
    private static final String CCU_URL = "http://ccu";
    private static final String DEVICE_KEYS = "/webui/webui.js";
    private static final String DESCRIPTION_KEYS = "/webui/js/lang/{LANGUAGE}/translate.lang.stringtable.js";
    private static final String DESCRIPTION_DESCRIPTIONS = "/webui/js/lang/{LANGUAGE}/translate.lang.deviceDescription.js";
    private static final String MASTER_LANG_PATH = "/config/easymodes/MASTER_LANG/";
    private static final String[] MASTER_LANG_FILES = new String[]{"HEATINGTHERMOSTATE_2ND_GEN.js", "HM_ES_PMSw.js"};
    private static final String[] LANGUAGES = new String[]{"en", "de"};

    public static void main(String[] args) {
        try {
            CcuMetadataExtractor dg = new CcuMetadataExtractor();
            dg.generate();
        }
        catch (IOException ex) {
            System.err.println(ex.getMessage());
        }
    }

    private void generate() throws IOException {
        Map<String, String> deviceKeys = this.loadDeviceKeys();
        String[] stringArray = LANGUAGES;
        int n = LANGUAGES.length;
        int n2 = 0;
        while (n2 < n) {
            String lang = stringArray[n2];
            Map<String, String> langDescriptions = this.loadJsonLangDescriptionFile("http://ccu/webui/js/lang/{LANGUAGE}/translate.lang.stringtable.js", lang);
            String[] stringArray2 = MASTER_LANG_FILES;
            int n3 = MASTER_LANG_FILES.length;
            int n4 = 0;
            while (n4 < n3) {
                String fileName = stringArray2[n4];
                langDescriptions.putAll(this.loadJsonLangDescriptionFile("http://ccu/config/easymodes/MASTER_LANG/" + fileName, lang));
                ++n4;
            }
            Map<String, String> deviceDescriptions = this.loadJsonLangDescriptionFile("http://ccu/webui/js/lang/{LANGUAGE}/translate.lang.deviceDescription.js", lang);
            String langIdent = "en".equals(lang) ? "" : "_" + lang;
            File file = new File("./src/main/resources/homematic/generated-descriptions" + langIdent + ".properties");
            System.out.println("Writing file " + file.getAbsolutePath());
            if (file.exists()) {
                file.delete();
            }
            file.createNewFile();
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "ISO-8859-1"));
            bw.write("# -------------- generated descriptions " + new Date() + " --------------\n");
            bw.write("# DON'T CHANGE THIS FILE!\n\n");
            for (Map.Entry<String, String> entry : deviceDescriptions.entrySet()) {
                bw.write(entry.getKey());
                bw.write("=");
                bw.write(entry.getValue());
                bw.write("\n");
            }
            bw.write("\n\n\n");
            for (Map.Entry<String, String> entry : deviceKeys.entrySet()) {
                String description = langDescriptions.get(entry.getValue());
                if (description == null) {
                    System.out.println("WARNING: Can't find a translation for " + entry.getValue());
                    continue;
                }
                bw.write(entry.getKey().toUpperCase());
                bw.write("=");
                bw.write(description);
                bw.write("\n");
            }
            bw.flush();
            bw.close();
            ++n2;
        }
    }

    private Map<String, String> loadJsonLangDescriptionFile(String url, String lang) throws IOException {
        final TreeMap<String, String> descriptions = new TreeMap<String, String>();
        String descriptionUrl = StringUtils.replace((String)url, (String)"{LANGUAGE}", (String)lang);
        String startLine = "  \"" + lang + "\" : {";
        String endLine = "  },";
        new UrlLoader(this, descriptionUrl, startLine, endLine){

            @Override
            public void line(String line) {
                String[] entry = this.handleStringTable(line);
                if (entry != null) {
                    descriptions.put(StringUtils.trim((String)entry[0]), this.unescape(StringUtils.trim((String)entry[1])));
                }
            }
        };
        return descriptions;
    }

    private Map<String, String> loadDeviceKeys() throws IOException {
        final TreeMap<String, String> deviceKeys = new TreeMap<String, String>();
        new UrlLoader(this, "http://ccu/webui/webui.js"){

            @Override
            public void line(String line) {
                if (line.startsWith("elvST['")) {
                    line = StringUtils.remove((String)line, (String)"elvST['");
                    line = StringUtils.replace((String)line, (String)"'] = '", (String)"=");
                    line = StringUtils.remove((String)line, (String)"';");
                    line = StringUtils.remove((String)line, (String)"$");
                    line = StringUtils.remove((String)line, (String)"{");
                    int count = StringUtils.countMatches((String)(line = StringUtils.remove((String)line, (String)"}")), (String)"=");
                    if (count > 1) {
                        line = StringUtils.replace((String)line, (String)"=", (String)"|", (int)1);
                    }
                    String[] split = StringUtils.split((String)line, (String)"=", (int)2);
                    deviceKeys.put(StringUtils.trim((String)split[0]), StringUtils.trim((String)split[1]));
                }
            }
        };
        return deviceKeys;
    }

    private String[] handleStringTable(String line) {
        line = StringUtils.remove((String)line, (String)"    \"");
        line = StringUtils.remove((String)line, (String)"\",");
        String[] splitted = StringUtils.split((String)(line = StringUtils.remove((String)line, (String)"\"")), (String)":", (int)2);
        return splitted.length != 2 ? null : splitted;
    }

    private String unescape(String str) {
        str = StringUtils.replace((String)str, (String)"%FC", (String)"\u00fc");
        str = StringUtils.replace((String)str, (String)"%DC", (String)"\u00dc");
        str = StringUtils.replace((String)str, (String)"%E4", (String)"\u00e4");
        str = StringUtils.replace((String)str, (String)"%C4", (String)"\u00c4");
        str = StringUtils.replace((String)str, (String)"%F6", (String)"\u00f6");
        str = StringUtils.replace((String)str, (String)"%D6", (String)"\u00d6");
        str = StringUtils.replace((String)str, (String)"%DF", (String)"\u00df");
        str = StringUtils.remove((String)str, (String)"&nbsp;");
        str = StringUtils.replace((String)str, (String)"<br/>", (String)" ");
        str = StringEscapeUtils.unescapeHtml((String)str);
        return str;
    }

    private abstract class UrlLoader {
        public UrlLoader(String url) throws IOException {
            this(url, null, null);
        }

        public UrlLoader(String url, String startLine, String endLine) throws IOException {
            String line;
            System.out.println("Loading file " + url);
            Boolean includeLine = null;
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL(url).openStream(), "ISO-8859-1"));
            while ((line = br.readLine()) != null) {
                if (startLine != null) {
                    if (line.equals(startLine)) {
                        includeLine = true;
                        continue;
                    }
                    if (line.equals(endLine) || includeLine == null) {
                        includeLine = false;
                    }
                }
                if (includeLine != null && !includeLine.booleanValue() || !StringUtils.isNotBlank((String)line)) continue;
                this.line(line);
            }
            br.close();
        }

        public abstract void line(String var1);
    }
}

