/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.LifxSelectorContext;
import org.eclipse.smarthome.binding.lifx.internal.LifxSequenceNumberSupplier;
import org.eclipse.smarthome.binding.lifx.internal.fields.MACAddress;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLabelRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetVersionRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Product;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLabelResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateServiceResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateVersionResponse;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxMessageUtil;
import org.eclipse.smarthome.binding.lifx.internal.util.LifxSelectorUtil;
import org.eclipse.smarthome.config.discovery.AbstractDiscoveryService;
import org.eclipse.smarthome.config.discovery.DiscoveryResult;
import org.eclipse.smarthome.config.discovery.DiscoveryResultBuilder;
import org.eclipse.smarthome.config.discovery.DiscoveryService;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={DiscoveryService.class}, configurationPid="discovery.lifx")
@NonNullByDefault
public class LifxLightDiscovery
extends AbstractDiscoveryService {
    private static final String LOG_ID = "Discovery";
    private static final long REFRESH_INTERVAL = TimeUnit.MINUTES.toSeconds(1L);
    private static final long SELECTOR_TIMEOUT = TimeUnit.SECONDS.toMillis(10L);
    private final Logger logger = LoggerFactory.getLogger(LifxLightDiscovery.class);
    private final Map<MACAddress, @Nullable DiscoveredLight> discoveredLights = new HashMap<MACAddress, DiscoveredLight>();
    private final long sourceId = LifxMessageUtil.randomSourceId();
    private final Supplier<Integer> sequenceNumberSupplier = new LifxSequenceNumberSupplier();
    private @Nullable Selector selector;
    private @Nullable SelectionKey broadcastKey;
    private @Nullable ScheduledFuture<?> discoveryJob;
    private @Nullable ScheduledFuture<?> networkJob;
    private boolean isScanning = false;

    public LifxLightDiscovery() throws IllegalArgumentException {
        super(LifxBindingConstants.SUPPORTED_THING_TYPES, 1, true);
    }

    @Activate
    protected void activate(@Nullable Map<String, @Nullable Object> configProperties) {
        super.activate(configProperties);
    }

    @Modified
    protected void modified(@Nullable Map<String, @Nullable Object> configProperties) {
        super.modified(configProperties);
    }

    @Deactivate
    protected void deactivate() {
        super.deactivate();
    }

    protected void startBackgroundDiscovery() {
        this.logger.debug("Starting the LIFX device background discovery");
        ScheduledFuture<?> localDiscoveryJob = this.discoveryJob;
        if (localDiscoveryJob == null || localDiscoveryJob.isCancelled()) {
            this.discoveryJob = this.scheduler.scheduleWithFixedDelay(this::doScan, 0L, REFRESH_INTERVAL, TimeUnit.SECONDS);
        }
    }

    protected void stopBackgroundDiscovery() {
        ScheduledFuture<?> localNetworkJob;
        this.logger.debug("Stopping LIFX device background discovery");
        ScheduledFuture<?> localDiscoveryJob = this.discoveryJob;
        if (localDiscoveryJob != null && !localDiscoveryJob.isCancelled()) {
            localDiscoveryJob.cancel(true);
            this.discoveryJob = null;
        }
        if ((localNetworkJob = this.networkJob) != null && !localNetworkJob.isCancelled()) {
            localNetworkJob.cancel(true);
            this.networkJob = null;
        }
    }

    protected void startScan() {
        this.doScan();
    }

    protected synchronized void stopScan() {
        super.stopScan();
        this.removeOlderResults(this.getTimestampOfLastScan());
    }

    protected void doScan() {
        try {
            if (!this.isScanning) {
                Selector localSelector;
                this.isScanning = true;
                if (this.selector != null) {
                    LifxSelectorUtil.closeSelector(this.selector, LOG_ID);
                }
                this.logger.debug("The LIFX discovery service will use '{}' as source identifier", (Object)Long.toString(this.sourceId, 16));
                this.selector = localSelector = Selector.open();
                this.broadcastKey = LifxSelectorUtil.openBroadcastChannel(localSelector, LOG_ID, 56700);
                this.networkJob = this.scheduler.schedule(this::receiveAndHandlePackets, 0L, TimeUnit.MILLISECONDS);
                LifxSelectorContext selectorContext = new LifxSelectorContext(localSelector, this.sourceId, this.sequenceNumberSupplier, LOG_ID, this.broadcastKey);
                LifxSelectorUtil.broadcastPacket(selectorContext, new GetServiceRequest());
            } else {
                this.logger.info("A discovery scan for LIFX lights is already underway");
            }
        }
        catch (Exception e) {
            this.logger.debug("{} while discovering LIFX lights : {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    public void receiveAndHandlePackets() {
        Selector localSelector = this.selector;
        try {
            if (localSelector == null || !localSelector.isOpen()) {
                this.logger.debug("Unable to receive and handle packets with null or closed selector");
                return;
            }
            try {
                this.discoveredLights.clear();
                this.logger.trace("Entering read loop");
                long startStamp = System.currentTimeMillis();
                while (System.currentTimeMillis() - startStamp < SELECTOR_TIMEOUT) {
                    boolean preventBusyWaiting;
                    boolean discoveredNewLights;
                    int lightCount = this.discoveredLights.size();
                    long selectStamp = System.currentTimeMillis();
                    LifxSelectorUtil.receiveAndHandlePackets(localSelector, LOG_ID, (packet, address) -> this.handlePacket((Packet)packet, (InetSocketAddress)address));
                    this.requestAdditionalLightData();
                    boolean bl = discoveredNewLights = lightCount < this.discoveredLights.size();
                    if (discoveredNewLights) continue;
                    boolean bl2 = preventBusyWaiting = System.currentTimeMillis() - selectStamp < 50L;
                    if (!preventBusyWaiting) continue;
                    Thread.sleep(50L);
                }
                this.logger.trace("Exited read loop");
            }
            catch (Exception e) {
                this.logger.debug("{} while receiving and handling discovery packets: {}", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
            }
        }
        finally {
            LifxSelectorUtil.closeSelector(localSelector, LOG_ID);
            this.selector = null;
            this.isScanning = false;
        }
    }

    private void requestAdditionalLightData() {
        for (DiscoveredLight light : this.discoveredLights.values()) {
            boolean waitingForLightResponse;
            if (light == null) continue;
            boolean bl = waitingForLightResponse = System.currentTimeMillis() - light.lastRequestTimeMillis < 200L;
            if (!light.supportedProduct || light.isDataComplete() || waitingForLightResponse) continue;
            if (light.product == null) {
                LifxSelectorUtil.sendPacket(light.selectorContext, new GetVersionRequest());
            }
            if (light.label == null) {
                LifxSelectorUtil.sendPacket(light.selectorContext, new GetLabelRequest());
            }
            light.lastRequestTimeMillis = System.currentTimeMillis();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void handlePacket(Packet packet, InetSocketAddress address) {
        this.logger.trace("Discovery : Packet type '{}' received from '{}' for '{}' with sequence '{}' and source '{}'", new Object[]{packet.getClass().getSimpleName(), address.toString(), packet.getTarget().getHex(), packet.getSequence(), Long.toString(packet.getSource(), 16)});
        if (packet.getSource() == this.sourceId || packet.getSource() == 0L) {
            macAddress = packet.getTarget();
            light = this.discoveredLights.get(macAddress);
            if (packet instanceof StateServiceResponse) {
                port = (int)((StateServiceResponse)packet).getPort();
                if (port != 0) {
                    try {
                        socketAddress = new InetSocketAddress(address.getAddress(), port);
                        if (light != null && socketAddress.equals(DiscoveredLight.access$6(light))) ** GOTO lbl35
                        if (light != null) {
                            light.cancelUnicastKey();
                        }
                        if ((lightSelector = this.selector) == null) ** GOTO lbl35
                        logId = LifxSelectorUtil.getLogId(macAddress, socketAddress);
                        light = new DiscoveredLight(lightSelector, macAddress, socketAddress, logId, LifxSelectorUtil.openUnicastChannel(lightSelector, logId, socketAddress));
                        this.discoveredLights.put(macAddress, light);
                    }
                    catch (Exception e) {
                        this.logger.warn("{} while connecting to IP address: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
                        return;
                    }
                }
            } else if (light != null) {
                if (packet instanceof StateLabelResponse) {
                    DiscoveredLight.access$7(light, ((StateLabelResponse)packet).getLabel().trim());
                } else if (packet instanceof StateVersionResponse) {
                    try {
                        DiscoveredLight.access$8(light, Product.getProductFromProductID(((StateVersionResponse)packet).getProduct()));
                        DiscoveredLight.access$9(light, ((StateVersionResponse)packet).getVersion());
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.debug("Discovered an unsupported light ({}): {}", (Object)DiscoveredLight.access$10(light).getAsLabel(), (Object)e.getMessage());
                        DiscoveredLight.access$11(light, false);
                    }
                }
            }
lbl35:
            // 11 sources

            if (light != null && light.isDataComplete()) {
                try {
                    this.thingDiscovered(this.createDiscoveryResult(light));
                }
                catch (IllegalArgumentException e) {
                    this.logger.trace("{} while creating discovery result of light ({})", new Object[]{e.getClass().getSimpleName(), DiscoveredLight.access$12(light), e});
                }
            }
        }
    }

    private DiscoveryResult createDiscoveryResult(DiscoveredLight light) throws IllegalArgumentException {
        Product product = light.product;
        if (product == null) {
            throw new IllegalArgumentException("Product of discovered light is null");
        }
        String macAsLabel = light.macAddress.getAsLabel();
        ThingUID thingUID = new ThingUID(product.getThingTypeUID(), macAsLabel);
        String label = light.label;
        if (StringUtils.isBlank((String)label)) {
            label = product.getName();
        }
        this.logger.trace("Discovered a LIFX light: {}", (Object)label);
        DiscoveryResultBuilder builder = DiscoveryResultBuilder.create((ThingUID)thingUID);
        builder.withRepresentationProperty("macAddress");
        builder.withLabel(label);
        builder.withProperty("deviceId", (Object)macAsLabel);
        builder.withProperty("macAddress", (Object)macAsLabel);
        builder.withProperty("productId", (Object)product.getID());
        builder.withProperty("productName", (Object)product.getName());
        builder.withProperty("productVersion", (Object)light.productVersion);
        builder.withProperty("vendorId", (Object)product.getVendor().getID());
        builder.withProperty("vendorName", (Object)product.getVendor().getName());
        return builder.build();
    }

    private class DiscoveredLight {
        private MACAddress macAddress;
        private InetSocketAddress socketAddress;
        private String logId;
        private @Nullable String label;
        private @Nullable Product product;
        private long productVersion;
        private boolean supportedProduct = true;
        private LifxSelectorContext selectorContext;
        private long lastRequestTimeMillis;

        public DiscoveredLight(Selector lightSelector, MACAddress macAddress, InetSocketAddress socketAddress, @Nullable String logId, SelectionKey unicastKey) {
            this.macAddress = macAddress;
            this.logId = logId;
            this.socketAddress = socketAddress;
            this.selectorContext = new LifxSelectorContext(lightSelector, LifxLightDiscovery.this.sourceId, LifxLightDiscovery.this.sequenceNumberSupplier, logId, socketAddress, macAddress, LifxLightDiscovery.this.broadcastKey, unicastKey);
        }

        public boolean isDataComplete() {
            return this.label != null && this.product != null;
        }

        public void cancelUnicastKey() {
            SelectionKey unicastKey = this.selectorContext.getUnicastKey();
            if (unicastKey != null) {
                LifxSelectorUtil.cancelKey(unicastKey, this.selectorContext.getLogId());
            }
        }

        static /* synthetic */ InetSocketAddress access$6(DiscoveredLight discoveredLight) {
            return discoveredLight.socketAddress;
        }

        static /* synthetic */ void access$7(DiscoveredLight discoveredLight, String string) {
            discoveredLight.label = string;
        }

        static /* synthetic */ void access$8(DiscoveredLight discoveredLight, Product product) {
            discoveredLight.product = product;
        }

        static /* synthetic */ void access$9(DiscoveredLight discoveredLight, long l) {
            discoveredLight.productVersion = l;
        }

        static /* synthetic */ void access$11(DiscoveredLight discoveredLight, boolean bl) {
            discoveredLight.supportedProduct = bl;
        }

        static /* synthetic */ String access$12(DiscoveredLight discoveredLight) {
            return discoveredLight.logId;
        }
    }
}

