/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.listener.LifxLightStateListener;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SignalStrength;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.PercentType;

@NonNullByDefault
public class LifxLightState {
    private HSBK[] colors = new HSBK[]{new HSBK(LifxBindingConstants.DEFAULT_COLOR)};
    private @Nullable PercentType infrared;
    private @Nullable PowerState powerState;
    private @Nullable SignalStrength signalStrength;
    private LocalDateTime lastChange = LocalDateTime.MIN;
    private List<LifxLightStateListener> listeners = new CopyOnWriteArrayList<LifxLightStateListener>();

    public void copy(LifxLightState other) {
        this.powerState = other.getPowerState();
        this.colors = other.getColors();
        this.infrared = other.getInfrared();
        this.signalStrength = other.getSignalStrength();
    }

    public @Nullable PowerState getPowerState() {
        return this.powerState;
    }

    public HSBK getColor() {
        return this.colors.length > 0 ? new HSBK(this.colors[0]) : new HSBK(LifxBindingConstants.DEFAULT_COLOR);
    }

    public HSBK getColor(int zoneIndex) {
        return zoneIndex < this.colors.length ? new HSBK(this.colors[zoneIndex]) : new HSBK(LifxBindingConstants.DEFAULT_COLOR);
    }

    public HSBK[] getColors() {
        HSBK[] colorsCopy = new HSBK[this.colors.length];
        int i = 0;
        while (i < this.colors.length) {
            colorsCopy[i] = this.colors[i] != null ? new HSBK(this.colors[i]) : null;
            ++i;
        }
        return colorsCopy;
    }

    public @Nullable PercentType getInfrared() {
        return this.infrared;
    }

    public @Nullable SignalStrength getSignalStrength() {
        return this.signalStrength;
    }

    public void setColor(HSBType newHSB) {
        HSBK newColor = this.getColor();
        newColor.setHSB(newHSB);
        this.setColor(newColor);
    }

    public void setColor(HSBType newHSB, int zoneIndex) {
        HSBK newColor = this.getColor(zoneIndex);
        newColor.setHSB(newHSB);
        this.setColor(newColor, zoneIndex);
    }

    public void setBrightness(PercentType brightness) {
        HSBK[] newColors;
        HSBK[] hSBKArray = newColors = this.getColors();
        int n = newColors.length;
        int n2 = 0;
        while (n2 < n) {
            HSBK newColor = hSBKArray[n2];
            newColor.setBrightness(brightness);
            ++n2;
        }
        this.setColors(newColors);
    }

    public void setBrightness(PercentType brightness, int zoneIndex) {
        HSBK newColor = this.getColor(zoneIndex);
        newColor.setBrightness(brightness);
        this.setColor(newColor, zoneIndex);
    }

    public void setColor(HSBK newColor) {
        Object[] newColors = this.getColors();
        Arrays.fill(newColors, newColor);
        this.setColors((HSBK[])newColors);
    }

    public void setColor(HSBK newColor, int zoneIndex) {
        HSBK[] newColors = this.getColors();
        newColors[zoneIndex] = newColor;
        this.setColors(newColors);
    }

    public void setColors(HSBK[] newColors) {
        HSBK[] oldColors = this.colors;
        this.colors = newColors;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleColorsChange(oldColors, newColors));
    }

    public void setPowerState(OnOffType newOnOff) {
        this.setPowerState(PowerState.fromOnOffType(newOnOff));
    }

    public void setPowerState(PowerState newPowerState) {
        PowerState oldPowerState = this.powerState;
        this.powerState = newPowerState;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handlePowerStateChange(oldPowerState, newPowerState));
    }

    public void setTemperature(int kelvin) {
        HSBK[] newColors;
        HSBK[] hSBKArray = newColors = this.getColors();
        int n = newColors.length;
        int n2 = 0;
        while (n2 < n) {
            HSBK newColor = hSBKArray[n2];
            newColor.setKelvin(kelvin);
            ++n2;
        }
        this.setColors(newColors);
    }

    public void setTemperature(int kelvin, int zoneIndex) {
        HSBK newColor = this.getColor(zoneIndex);
        newColor.setKelvin(kelvin);
        this.setColor(newColor, zoneIndex);
    }

    public void setInfrared(PercentType newInfrared) {
        PercentType oldInfrared = this.infrared;
        this.infrared = newInfrared;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleInfraredChange(oldInfrared, newInfrared));
    }

    public void setSignalStrength(SignalStrength newSignalStrength) {
        SignalStrength oldSignalStrength = this.signalStrength;
        this.signalStrength = newSignalStrength;
        this.updateLastChange();
        this.listeners.forEach(listener -> listener.handleSignalStrengthChange(oldSignalStrength, newSignalStrength));
    }

    private void updateLastChange() {
        this.lastChange = LocalDateTime.now();
    }

    public Duration getDurationSinceLastChange() {
        return Duration.between(this.lastChange, LocalDateTime.now());
    }

    public void addListener(LifxLightStateListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(LifxLightStateListener listener) {
        this.listeners.remove(listener);
    }
}

