/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import java.nio.ByteBuffer;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;

@NonNullByDefault
public class HSBKField
extends Field<HSBK> {
    public static final Field<Integer> FIELD_HUE = new UInt16Field().little();
    public static final Field<Integer> FIELD_SATURATION = new UInt16Field().little();
    public static final Field<Integer> FIELD_BRIGHTNESS = new UInt16Field().little();
    public static final Field<Integer> FIELD_KELVIN = new UInt16Field().little();

    @Override
    public int defaultLength() {
        return 8;
    }

    @Override
    public HSBK value(ByteBuffer bytes) {
        int hue = FIELD_HUE.value(bytes);
        int saturation = FIELD_SATURATION.value(bytes);
        int brightness = FIELD_BRIGHTNESS.value(bytes);
        int kelvin = FIELD_KELVIN.value(bytes);
        return new HSBK(hue, saturation, brightness, kelvin);
    }

    @Override
    protected ByteBuffer bytesInternal(HSBK value) {
        return ByteBuffer.allocate(this.defaultLength()).put(FIELD_HUE.bytes(value.getHue())).put(FIELD_SATURATION.bytes(value.getSaturation())).put(FIELD_BRIGHTNESS.bytes(value.getBrightness())).put(FIELD_KELVIN.bytes(value.getKelvin()));
    }
}

