/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.fields;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;

@NonNullByDefault
public class StringField
extends Field<String> {
    public static final Charset CHARSET = StandardCharsets.US_ASCII;
    private Charset charset;

    public StringField() {
        this.charset = StandardCharsets.US_ASCII;
    }

    public StringField(int length) {
        super(length);
        this.charset = StandardCharsets.US_ASCII;
    }

    public StringField(int length, Charset charset) {
        super(length);
        this.charset = charset;
    }

    @Override
    public int defaultLength() {
        return 3;
    }

    @Override
    public String value(ByteBuffer bytes) {
        byte[] buf = new byte[this.length];
        bytes.get(buf);
        ByteBuffer field = ByteBuffer.wrap(buf);
        String ret = this.charset.decode(field).toString();
        ret = ret.replace("\u0000", "");
        return ret;
    }

    @Override
    public ByteBuffer bytesInternal(String value) {
        return CHARSET.encode(value);
    }

    public StringField ascii() {
        this.charset = StandardCharsets.US_ASCII;
        return this;
    }

    public StringField utf8() {
        this.charset = StandardCharsets.UTF_8;
        return this;
    }
}

