/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.binding.lifx.internal.protocol.AcknowledgementResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.EchoRequestResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GenericHandler;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetColorZonesRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetEchoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetGroupRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetHostFirmwareRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetHostInfoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetInfoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLabelRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightInfraredRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLightPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetLocationRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetServiceRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetTagLabelsRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetTagsRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetVersionRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetWifiFirmwareRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.GetWifiInfoRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PacketHandler;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetColorRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetColorZonesRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetDimAbsoluteRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetLabelRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetLightInfraredRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetLightPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetPowerRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.SetTagsRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateGroupResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateHostFirmwareResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateHostInfoResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateInfoResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLabelResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLightInfraredResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLightPowerResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateLocationResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateMultiZoneResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StatePowerResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateServiceResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateVersionResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateWifiFirmwareResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateWifiInfoResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.StateZoneResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.TagLabelsResponse;
import org.eclipse.smarthome.binding.lifx.internal.protocol.TagsResponse;

@NonNullByDefault
public class PacketFactory {
    private static @Nullable PacketFactory instance;
    private final Map<Integer, PacketHandler<?>> handlers = new HashMap();

    public static synchronized PacketFactory getInstance() {
        PacketFactory result = instance;
        if (result == null) {
            instance = result = new PacketFactory();
        }
        return result;
    }

    private PacketFactory() {
        this.register(AcknowledgementResponse.class);
        this.register(EchoRequestResponse.class);
        this.register(GetColorZonesRequest.class);
        this.register(GetEchoRequest.class);
        this.register(GetGroupRequest.class);
        this.register(GetHostFirmwareRequest.class);
        this.register(GetHostInfoRequest.class);
        this.register(GetInfoRequest.class);
        this.register(GetLabelRequest.class);
        this.register(GetLightInfraredRequest.class);
        this.register(GetLightPowerRequest.class);
        this.register(GetLocationRequest.class);
        this.register(GetPowerRequest.class);
        this.register(GetRequest.class);
        this.register(GetServiceRequest.class);
        this.register(GetTagLabelsRequest.class);
        this.register(GetTagsRequest.class);
        this.register(GetVersionRequest.class);
        this.register(GetWifiFirmwareRequest.class);
        this.register(GetWifiInfoRequest.class);
        this.register(SetColorRequest.class);
        this.register(SetColorZonesRequest.class);
        this.register(SetDimAbsoluteRequest.class);
        this.register(SetLabelRequest.class);
        this.register(SetLightInfraredRequest.class);
        this.register(SetLightPowerRequest.class);
        this.register(SetPowerRequest.class);
        this.register(SetTagsRequest.class);
        this.register(StateGroupResponse.class);
        this.register(StateHostFirmwareResponse.class);
        this.register(StateHostInfoResponse.class);
        this.register(StateInfoResponse.class);
        this.register(StateLabelResponse.class);
        this.register(StateLightInfraredResponse.class);
        this.register(StateLightPowerResponse.class);
        this.register(StateLocationResponse.class);
        this.register(StateMultiZoneResponse.class);
        this.register(StatePowerResponse.class);
        this.register(StateResponse.class);
        this.register(StateServiceResponse.class);
        this.register(StateVersionResponse.class);
        this.register(StateWifiFirmwareResponse.class);
        this.register(StateWifiInfoResponse.class);
        this.register(StateZoneResponse.class);
        this.register(TagLabelsResponse.class);
        this.register(TagsResponse.class);
    }

    public final void register(int type, PacketHandler<?> handler) {
        this.handlers.put(type, handler);
    }

    public final void register(int type, Class<? extends Packet> clazz) {
        this.handlers.put(type, new GenericHandler<Packet>(clazz));
    }

    public final <T extends Packet> void register(Class<T> clazz) {
        GenericHandler<T> handler = new GenericHandler<T>(clazz);
        if (!handler.isTypeFound()) {
            throw new IllegalArgumentException("Unable to register generic packet with no TYPE field.");
        }
        this.handlers.put(handler.getType(), handler);
    }

    public @Nullable PacketHandler<?> getHandler(int packetType) {
        return this.handlers.get(packetType);
    }

    public static @Nullable PacketHandler<?> createHandler(int packetType) {
        return PacketFactory.getInstance().getHandler(packetType);
    }
}

