/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.util.Arrays;
import java.util.EnumSet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.binding.lifx.LifxBindingConstants;
import org.eclipse.smarthome.core.thing.ThingTypeUID;

@NonNullByDefault
public enum Product {
    PRODUCT_1(1L, "Original 1000", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_3(3L, "Color 650", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_10(10L, "White 800 (Low Voltage)", TemperatureRange.TR_2700_6500),
    PRODUCT_11(11L, "White 800 (High Voltage)", TemperatureRange.TR_2700_6500),
    PRODUCT_18(18L, "White 900 BR30 (Low Voltage)", TemperatureRange.TR_2700_6500),
    PRODUCT_20(20L, "Color 1000 BR30", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_22(22L, "Color 1000", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_27(27L, "LIFX A19", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_28(28L, "LIFX BR30", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_29(29L, "LIFX+ A19", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.INFRARED),
    PRODUCT_30(30L, "LIFX+ BR30", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.INFRARED),
    PRODUCT_31(31L, "LIFX Z", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.MULTIZONE),
    PRODUCT_32(32L, "LIFX Z 2", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.MULTIZONE),
    PRODUCT_36(36L, "LIFX Downlight", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_37(37L, "LIFX Downlight", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_38(38L, "LIFX Beam", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.MULTIZONE),
    PRODUCT_43(43L, "LIFX A19", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_44(44L, "LIFX BR30", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_45(45L, "LIFX+ A19", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.INFRARED),
    PRODUCT_46(46L, "LIFX+ BR30", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.INFRARED),
    PRODUCT_49(49L, "LIFX Mini", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_50(50L, "LIFX Mini Day and Dusk", TemperatureRange.TR_1500_4000),
    PRODUCT_51(51L, "LIFX Mini White", TemperatureRange.TR_2700_2700),
    PRODUCT_52(52L, "LIFX GU10", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_55(55L, "LIFX Tile", TemperatureRange.TR_2500_9000, Feature.CHAIN, Feature.COLOR),
    PRODUCT_56(56L, "LIFX Beam", TemperatureRange.TR_2500_9000, Feature.COLOR, Feature.MULTIZONE),
    PRODUCT_59(59L, "LIFX Mini Color", TemperatureRange.TR_2500_9000, Feature.COLOR),
    PRODUCT_60(60L, "LIFX Mini Day and Dusk", TemperatureRange.TR_1500_4000),
    PRODUCT_61(61L, "LIFX Mini White", TemperatureRange.TR_2700_2700);

    private final Vendor vendor;
    private final long id;
    private final String name;
    private final TemperatureRange temperatureRange;
    private final EnumSet<Feature> features = EnumSet.noneOf(Feature.class);

    private Product(long id, String name, TemperatureRange temperatureRange) {
        this(Vendor.LIFX, id, name, temperatureRange);
    }

    private Product(long id, String name, TemperatureRange temperatureRange, Feature ... features) {
        this(Vendor.LIFX, id, name, temperatureRange, features);
    }

    private Product(Vendor vendor, long id, String name, TemperatureRange temperatureRange) {
        this(vendor, id, name, temperatureRange, new Feature[0]);
    }

    private Product(Vendor vendor, long id, String name, TemperatureRange temperatureRange, Feature ... features) {
        this.vendor = vendor;
        this.id = id;
        this.name = name;
        this.temperatureRange = temperatureRange;
        this.features.addAll(Arrays.asList(features));
    }

    public String toString() {
        return this.name;
    }

    public Vendor getVendor() {
        return this.vendor;
    }

    public long getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TemperatureRange getTemperatureRange() {
        return this.temperatureRange;
    }

    public ThingTypeUID getThingTypeUID() {
        if (this.hasFeature(Feature.COLOR)) {
            if (this.hasFeature(Feature.INFRARED)) {
                return LifxBindingConstants.THING_TYPE_COLORIRLIGHT;
            }
            if (this.hasFeature(Feature.MULTIZONE)) {
                return LifxBindingConstants.THING_TYPE_COLORMZLIGHT;
            }
            return LifxBindingConstants.THING_TYPE_COLORLIGHT;
        }
        return LifxBindingConstants.THING_TYPE_WHITELIGHT;
    }

    public boolean hasFeature(Feature feature) {
        return this.features.contains((Object)feature);
    }

    public static Product getLikelyProduct(ThingTypeUID uid) throws IllegalArgumentException {
        Product[] productArray = Product.values();
        int n = productArray.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            if (product.getThingTypeUID().equals((Object)uid)) {
                return product;
            }
            ++n2;
        }
        throw new IllegalArgumentException(uid + " is not a valid product thing type UID");
    }

    public static Product getProductFromProductID(long id) throws IllegalArgumentException {
        Product[] productArray = Product.values();
        int n = productArray.length;
        int n2 = 0;
        while (n2 < n) {
            Product product = productArray[n2];
            if (product.id == id) {
                return product;
            }
            ++n2;
        }
        throw new IllegalArgumentException(String.valueOf(id) + " is not a valid product ID");
    }

    public static enum Feature {
        CHAIN,
        COLOR,
        INFRARED,
        MULTIZONE;

    }

    public static enum TemperatureRange {
        TR_1500_4000(1500, 4000),
        TR_2500_9000(2500, 9000),
        TR_2700_2700(2700, 2700),
        TR_2700_6500(2700, 6500);

        private final int minimum;
        private final int maximum;

        private TemperatureRange(int minimum, int maximum) {
            this.minimum = minimum;
            this.maximum = maximum;
        }

        public int getMinimum() {
            return this.minimum;
        }

        public int getMaximum() {
            return this.maximum;
        }

        public int getRange() {
            return this.maximum - this.minimum;
        }
    }

    public static enum Vendor {
        LIFX(1, "LIFX");

        private final int id;
        private final String name;

        private Vendor(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public int getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }
}

