/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBKField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt8Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.ApplicationRequest;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class SetColorZonesRequest
extends Packet {
    public static final int TYPE = 501;
    public static final Field<Integer> FIELD_START_INDEX = new UInt8Field();
    public static final Field<Integer> FIELD_END_INDEX = new UInt8Field();
    public static final HSBKField FIELD_COLOR = new HSBKField();
    public static final Field<Long> FIELD_FADE_TIME = new UInt32Field().little();
    public static final Field<Integer> FIELD_APPLY = new UInt8Field();
    private int startIndex = 0;
    private int endIndex = 255;
    private HSBK color;
    private long fadeTime;
    private ApplicationRequest apply;

    public HSBK getColor() {
        return this.color;
    }

    public int getHue() {
        return this.color.getHue();
    }

    public int getSaturation() {
        return this.color.getSaturation();
    }

    public int getBrightness() {
        return this.color.getBrightness();
    }

    public int getKelvin() {
        return this.color.getKelvin();
    }

    public long getFadeTime() {
        return this.fadeTime;
    }

    public ApplicationRequest getApply() {
        return this.apply;
    }

    public SetColorZonesRequest() {
        this.setTagged(false);
        this.setAddressable(true);
        this.setResponseRequired(true);
    }

    public SetColorZonesRequest(HSBK color, long fadeTime, ApplicationRequest apply) {
        this(0, 255, color, fadeTime, apply);
    }

    public SetColorZonesRequest(int index, HSBK color, long fadeTime, ApplicationRequest apply) {
        this(index, index, color, fadeTime, apply);
    }

    public SetColorZonesRequest(int startIndex, int endIndex, HSBK color, long fadeTime, ApplicationRequest apply) {
        this();
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.color = color;
        this.fadeTime = fadeTime;
        this.apply = apply;
    }

    @Override
    public int packetType() {
        return 501;
    }

    @Override
    protected int packetLength() {
        return 15;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.startIndex = FIELD_START_INDEX.value(bytes);
        this.endIndex = FIELD_END_INDEX.value(bytes);
        this.color = FIELD_COLOR.value(bytes);
        this.fadeTime = FIELD_FADE_TIME.value(bytes);
        this.apply = ApplicationRequest.fromValue(FIELD_APPLY.value(bytes));
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_START_INDEX.bytes(this.startIndex)).put(FIELD_END_INDEX.bytes(this.endIndex)).put(FIELD_COLOR.bytes(this.color)).put(FIELD_FADE_TIME.bytes(this.fadeTime)).put(FIELD_APPLY.bytes(this.apply.getValue()));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

