/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

public class SignalStrength {
    private double milliWatts;

    public SignalStrength(double milliWatts) {
        this.milliWatts = milliWatts;
    }

    public double getMilliWatts() {
        return this.milliWatts;
    }

    public double toQualityPercentage() {
        return Math.min(100.0, Math.max(0.0, 2.0 * (this.toRSSI() + 100.0))) / 100.0;
    }

    public byte toQualityRating() {
        return (byte)Math.round(this.toQualityPercentage() * 4.0);
    }

    public double toRSSI() {
        return 10.0 * Math.log10(this.milliWatts);
    }

    public String toString() {
        return "SignalStrength [milliWatts=" + this.milliWatts + ", rssi=" + Math.round(this.toRSSI()) + "]";
    }
}

