/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBK;
import org.eclipse.smarthome.binding.lifx.internal.fields.HSBKField;
import org.eclipse.smarthome.binding.lifx.internal.fields.StringField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt16Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt64Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;
import org.eclipse.smarthome.binding.lifx.internal.protocol.PowerState;

public class StateResponse
extends Packet {
    public static final int TYPE = 107;
    public static final HSBKField FIELD_COLOR = new HSBKField();
    public static final Field<Integer> FIELD_DIM = new UInt16Field().little();
    public static final Field<Integer> FIELD_POWER = new UInt16Field();
    public static final Field<String> FIELD_LABEL = new StringField(32);
    public static final Field<Long> FIELD_TAGS = new UInt64Field();
    private HSBK color;
    private int dim;
    private PowerState power;
    private String label;
    private long tags;

    public String toString() {
        return String.valueOf(this.color.toString("color")) + ", dim=" + this.dim + ", power=" + (Object)((Object)this.power) + ", label=" + this.label;
    }

    public HSBK getColor() {
        return this.color;
    }

    public int getDim() {
        return this.dim;
    }

    public PowerState getPower() {
        return this.power;
    }

    public String getLabel() {
        return this.label;
    }

    public long getTags() {
        return this.tags;
    }

    @Override
    public int packetType() {
        return 107;
    }

    @Override
    protected int packetLength() {
        return 52;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.color = FIELD_COLOR.value(bytes);
        this.dim = FIELD_DIM.value(bytes);
        this.power = PowerState.fromValue(FIELD_POWER.value(bytes));
        this.label = FIELD_LABEL.value(bytes);
        this.tags = FIELD_TAGS.value(bytes);
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_COLOR.bytes(this.color)).put(FIELD_DIM.bytes(this.dim)).put(FIELD_POWER.bytes(this.power.getValue())).put(FIELD_LABEL.bytes(this.label)).put(FIELD_TAGS.bytes(this.tags));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

