/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.lifx.internal.protocol;

import java.nio.ByteBuffer;
import org.eclipse.smarthome.binding.lifx.internal.fields.Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.LittleField;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt32Field;
import org.eclipse.smarthome.binding.lifx.internal.fields.UInt8Field;
import org.eclipse.smarthome.binding.lifx.internal.protocol.Packet;

public class StateServiceResponse
extends Packet {
    public static final int TYPE = 3;
    public static final Field<Integer> FIELD_SERVICE = new UInt8Field();
    public static final Field<Long> FIELD_PORT = new LittleField<Long>(new UInt32Field());
    private int service;
    private long port;

    public int getService() {
        return this.service;
    }

    public long getPort() {
        return this.port;
    }

    @Override
    protected void parsePacket(ByteBuffer bytes) {
        this.service = FIELD_SERVICE.value(bytes);
        this.port = FIELD_PORT.value(bytes);
    }

    @Override
    public int packetType() {
        return 3;
    }

    @Override
    protected int packetLength() {
        return 5;
    }

    @Override
    protected ByteBuffer packetBytes() {
        return ByteBuffer.allocate(this.packetLength()).put(FIELD_SERVICE.bytes(this.service)).put(FIELD_PORT.bytes(this.port));
    }

    @Override
    public int[] expectedResponses() {
        return new int[0];
    }
}

